/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusecsv.preprocessing;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.cishell.utilities.ArrayUtilities;
import org.cishell.utilities.FileUtilities;

public final class CSVFilePreprocessor {
    public static final int HEADER_INDEX = 0;
    public static final String DEFAULT_EMPTY_VALUE = "";
    public static final String DEFAULT_TITLE_PREFIX = "UNTITLED_";

    private CSVFilePreprocessor() {
    }

    public static File execute(String filePath) throws IOException {
        return CSVFilePreprocessor.execute(new File(filePath));
    }

    public static File execute(File file) throws IOException {
        if (file.exists()) {
            return CSVFilePreprocessor.preprocessCSVFile(file);
        }
        return file;
    }

    private static File preprocessCSVFile(File file) throws IOException {
        List<String[]> rows = CSVFilePreprocessor.readAllRowsFromCSVFile(file);
        CSVFilePreprocessor.cleanTailingEmptyStrings(rows);
        int columnSize = CSVFilePreprocessor.validateColumnSize(rows);
        CSVFilePreprocessor.balanceColumnsSizeOfTheRows(rows, columnSize);
        CSVFilePreprocessor.titleHeader(rows);
        File processedFile = CSVFilePreprocessor.createTempCSVFile(file);
        CSVFilePreprocessor.writeRowToCSVFile(processedFile, rows, columnSize);
        return processedFile;
    }

    private static int validateColumnSize(List<String[]> rows) {
        int maxSize = 0;
        for (String[] row : rows) {
            if (maxSize >= row.length) continue;
            maxSize = row.length;
        }
        return maxSize;
    }

    private static void titleHeader(List<String[]> rows) {
        int numberOfUntitledColumn = 0;
        if (rows.size() > 0) {
            String[] header = rows.get(0);
            int i = 0;
            while (i < header.length) {
                if (header[i].equals(DEFAULT_EMPTY_VALUE)) {
                    header[i] = DEFAULT_TITLE_PREFIX + String.valueOf(numberOfUntitledColumn++);
                }
                ++i;
            }
            rows.set(0, header);
        }
    }

    private static void cleanTailingEmptyStrings(List<String[]> rows) {
        int i = 0;
        while (i < rows.size()) {
            rows.set(i, CSVFilePreprocessor.removeTailingEmptyStringsInRow(rows.get(i)));
            ++i;
        }
    }

    private static String[] removeTailingEmptyStringsInRow(String[] row) {
        int size;
        int cuttedIndex = size = row.length;
        int i = cuttedIndex - 1;
        while (i >= 0) {
            if (!row[i].equals(DEFAULT_EMPTY_VALUE)) break;
            cuttedIndex = i--;
        }
        if (cuttedIndex != size) {
            return ArrayUtilities.copyOf((String[])row, (int)cuttedIndex);
        }
        return row;
    }

    private static List<String[]> readAllRowsFromCSVFile(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        CSVReader csvReader = new CSVReader((Reader)fileReader);
        List rows = csvReader.readAll();
        csvReader.close();
        return rows;
    }

    private static File createTempCSVFile(File file) throws IOException {
        String tempCSVFileName = "Preprocessed-" + FileUtilities.extractFileName((String)file.getName()) + "-";
        return FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)tempCSVFileName, (String)"csv");
    }

    private static void writeRowToCSVFile(File file, List<String[]> rows, int columnSize) throws IOException {
        CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(file));
        csvWriter.writeAll(rows);
        csvWriter.close();
    }

    private static void balanceColumnsSizeOfTheRows(List<String[]> rows, int columnSize) {
        int i = 0;
        while (i < rows.size()) {
            String[] row = rows.get(i);
            int remain = columnSize - row.length;
            if (remain > 0) {
                rows.set(i, CSVFilePreprocessor.expendRowWithEmptyString(rows.get(i), remain));
            }
            ++i;
        }
    }

    private static String[] expendRowWithEmptyString(String[] row, int expendedSize) {
        if (expendedSize > 0) {
            int oldSize = row.length;
            row = ArrayUtilities.copyOf((String[])row, (int)(oldSize + expendedSize));
            int i = oldSize;
            while (i < row.length) {
                row[i] = DEFAULT_EMPTY_VALUE;
                ++i;
            }
        }
        return row;
    }
}

