/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusecsv.reader;

import edu.iu.nwb.converter.prefusecsv.preprocessing.CSVFilePreprocessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import prefuse.data.Table;
import prefuse.data.io.CSVTableReader;
import prefuse.data.io.DataIOException;

public class PrefuseCsvReader
implements Algorithm {
    private File inCSVFile;

    public PrefuseCsvReader(Data[] data) {
        this.inCSVFile = (File)data[0].getData();
    }

    public PrefuseCsvReader(File inFile) {
        this.inCSVFile = inFile;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            File tmpCSVFile = CSVFilePreprocessor.execute(this.inCSVFile);
            CSVTableReader tableReader = new CSVTableReader();
            tableReader.setHasHeader(true);
            Table table = tableReader.readTable((InputStream)new FileInputStream(tmpCSVFile));
            return this.createOutData(tmpCSVFile, table);
        }
        catch (DataIOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private Data[] createOutData(File file, Table table) {
        Data[] dm = new Data[]{new BasicData((Object)table, Table.class.getName())};
        dm[0].getMetadata().put("Label", "Prefuse Table: " + file);
        dm[0].getMetadata().put("Type", "Table");
        return dm;
    }

    public static class Factory
    implements AlgorithmFactory {
        public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
            return new PrefuseCsvReader(data);
        }
    }
}

