/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusecsv.validator;

import edu.iu.nwb.converter.prefusecsv.preprocessing.CSVFilePreprocessor;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import prefuse.data.io.CSVTableReader;
import prefuse.data.io.DataIOException;

public class PrefuseCsvValidator
implements Algorithm {
    public static final String CSV_MIME_TYPE = "file:text/csv";
    private String inCSVFilePath;

    public PrefuseCsvValidator() {
    }

    public PrefuseCsvValidator(Data[] data) {
        this.inCSVFilePath = (String)data[0].getData();
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            File inputData = CSVFilePreprocessor.execute(this.inCSVFilePath);
            this.validateSelectedFileforCSVFormat(inputData.getAbsolutePath());
            return this.createOutData(inputData);
        }
        catch (SecurityException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private Data[] createOutData(File inputData) {
        Data[] validationData = new Data[]{new BasicData((Object)inputData, CSV_MIME_TYPE)};
        validationData[0].getMetadata().put("Label", "CSV file: " + inputData.getAbsolutePath());
        validationData[0].getMetadata().put("Type", "Table");
        return validationData;
    }

    public void validateSelectedFileforCSVFormat(String csvFileName) throws AlgorithmExecutionException {
        CSVTableReader csvValidator = new CSVTableReader();
        try {
            csvValidator.readTable(csvFileName);
        }
        catch (DataIOException e) {
            throw new AlgorithmExecutionException("Error reading tables: " + e.getMessage(), (Throwable)e);
        }
    }

    public static class Factory
    implements AlgorithmFactory {
        public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
            return new PrefuseCsvValidator(data);
        }
    }
}

