/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusegraphml.for_guess;

import edu.iu.nwb.converter.prefusegraphml.reader.PrefuseGraphMLReader;
import edu.iu.nwb.converter.prefusegraphml.writer.PrefuseGraphMLWriter;
import java.io.File;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;

public class GraphMLToGraphMLForGuessAlgorithm
implements Algorithm {
    public static final String GRAPH_ML_FOR_GUESS_MIME_TYPE = "file:text/graphml_for_guess+xml";
    public static final String DEFAULT_LABEL = "Untitled";
    private Data[] inputData;
    private CIShellContext context;

    public GraphMLToGraphMLForGuessAlgorithm(Data[] inputData, CIShellContext context) {
        this.inputData = inputData;
        this.context = context;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            Data[] graphData = new PrefuseGraphMLReader(this.inputData, true, this.context).execute();
            Data[] outputData = new PrefuseGraphMLWriter(graphData).execute();
            return this.createOutData(outputData);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Data[] createOutData(Data[] originalOutputData) {
        BasicData outputData = new BasicData((Object)((File)originalOutputData[0].getData()), GRAPH_ML_FOR_GUESS_MIME_TYPE);
        Dictionary inputMetadata = this.inputData[0].getMetadata();
        Dictionary outputMetadata = outputData.getMetadata();
        outputMetadata.put("Parent", this.inputData[0]);
        outputMetadata.put("Label", this.determineLabel(inputMetadata));
        outputMetadata.put("Type", "Network");
        return new Data[]{outputData};
    }

    private String determineLabel(Dictionary<String, Object> inputMetadata) {
        Object label = inputMetadata.get("Label");
        if (label != null) {
            return label.toString();
        }
        return DEFAULT_LABEL;
    }
}

