/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusegraphml.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.cishell.framework.CIShellContext;
import org.osgi.service.log.LogService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.io.AbstractGraphReader;
import prefuse.data.io.DataIOException;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.data.parser.ParserFactory;
import prefuse.util.collections.IntIterator;

public class GraphMLReaderModified
extends AbstractGraphReader {
    private boolean cleanForGUESS;
    private CIShellContext context;

    public GraphMLReaderModified(boolean cleanForGUESS, CIShellContext context) {
        this.cleanForGUESS = cleanForGUESS;
        this.context = context;
    }

    public Graph readGraph(InputStream input) throws DataIOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            GraphMLHandler handler = new GraphMLHandler(this.cleanForGUESS, this.context);
            saxParser.parse(input, (DefaultHandler)handler);
            return handler.getGraph();
        }
        catch (ParserConfigurationException e) {
            throw new DataIOException(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new DataIOException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new DataIOException(e.getMessage(), (Throwable)e);
        }
    }

    public static class GraphMLHandler
    extends DefaultHandler
    implements Tokens {
        public static final String SOURCE = Graph.DEFAULT_SOURCE_KEY;
        public static final String TARGET = Graph.DEFAULT_TARGET_KEY;
        public static final String SOURCE_ID = String.valueOf(SOURCE) + '_' + "id";
        public static final String TARGET_ID = String.valueOf(TARGET) + '_' + "id";
        protected ParserFactory parserFactory = ParserFactory.getDefaultFactory();
        protected Schema nodeSchema = new Schema();
        protected Schema edgeSchema = new Schema();
        protected String graphID;
        protected Graph graph;
        protected Table nodes;
        protected Table edges;
        protected String idAttribute;
        protected String forAttribute;
        protected String nameAttribute;
        protected String typeAttribute;
        protected String defaultValue;
        protected StringBuffer elementContents = new StringBuffer();
        private String currentKey;
        private int nodeRow = -1;
        private Table currentTable = null;
        protected HashMap<String, Integer> nodeIDsToRowNumbers = new HashMap();
        protected HashMap<String, String> idToNameMap = new HashMap();
        private boolean isDirected = false;
        private boolean inSchema;
        private boolean cleanForGUESS;
        private HashMap<String, Integer> attributeNameToCount = new HashMap();
        private HashMap<String, Integer> attributeIdToCount = new HashMap();
        private HashMap<String, Integer> attributeKeyToCount = new HashMap();
        private LogService logger;
        public static final String GUESS_ATTRIBUTE_COLOR = "color";
        public static final String GUESS_ATTRIBUTE_FIXED = "fixed";
        public static final String GUESS_ATTRIBUTE_HEIGHT = "height";
        public static final String GUESS_ATTRIBUTE_IMAGE = "image";
        public static final String GUESS_ATTRIBUTE_LABEL = "label";
        public static final String GUESS_ATTRIBUTE_LABEL_COLOR = "labelcolor";
        public static final String GUESS_ATTRIBUTE_LABEL_SIZE = "labelsize";
        public static final String GUESS_ATTRIBUTE_LABEL_VISIBLE = "labelvisible";
        public static final String GUESS_ATTRIBUTE_NAME = "name";
        public static final String GUESS_ATTRIBUTE_ORIGINAL_LABEL = "originallabel";
        public static final String GUESS_ATTRIBUTE_STROKE_COLOR = "strokecolor";
        public static final String GUESS_ATTRIBUTE_STYLE = "style";
        public static final String GUESS_ATTRIBUTE_VISIBLE = "visible";
        public static final String GUESS_ATTRIBUTE_WIDTH = "width";
        public static final String GUESS_ATTRIBUTE_X = "x";
        public static final String GUESS_ATTRIBUTE_Y = "y";
        public static final String GUESS_ATTRIBUTE_EDGE_ID = "__edgeid";
        public static final String GUESS_ATTRIBUTE_DIRECTED = "directed";
        public static final String GUESS_ATTRIBUTE_NODE_1 = "node1";
        public static final String GUESS_ATTRIBUTE_NODE_2 = "node2";
        public static final String GUESS_ATTRIBUTE_WEIGHT = "weight";
        public static final String GUESS_ATTRIBUTE_COUNT = "count";
        public static final String GUESS_ATTRIBUTE_SIZE = "size";
        public static final String GUESS_ATTRIBUTE_TYPE = "type";
        public static final Collection<String> DEFAULT_GUESS_NODES_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("id", "color", "fixed", "height", "image", "labelcolor", "labelsize", "labelvisible", "name", "originallabel", "strokecolor", "style", "visible", "width", "x", "y", "count", "size", "type")));
        public static final Collection<String> DEFAULT_GUESS_EDGE_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("__edgeid", "color", "directed", "labelcolor", "labelsize", "labelvisible", "node1", "node2", "originallabel", "visible", "width", SOURCE, TARGET)));
        public static final Collection<String> NODE_ATTRIBUTES_TO_IGNORE_MULTIPLE_DECLARATIONS_OF = Collections.unmodifiableSet(new HashSet());
        public static final Collection<String> EDGE_ATTRIBUTES_TO_IGNORE_MULTIPLE_DECLARATIONS_OF = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SOURCE, TARGET)));

        public GraphMLHandler(boolean cleanForGUESS, CIShellContext context) {
            this.cleanForGUESS = cleanForGUESS;
            this.logger = (LogService)context.getService("org.osgi.service.log.LogService");
        }

        @Override
        public void startDocument() {
            if (this.cleanForGUESS) {
                this.logger.log(2, "[Warning] The column names that conflict with the existing column or keywords used by the GUESS plugin will be renamed.");
            }
            this.nodeIDsToRowNumbers.clear();
            this.inSchema = true;
            this.edgeSchema.addColumn(SOURCE, Integer.TYPE);
            this.edgeSchema.addColumn(TARGET, Integer.TYPE);
            this.edgeSchema.addColumn(SOURCE_ID, String.class);
            this.edgeSchema.addColumn(TARGET_ID, String.class);
        }

        @Override
        public void endDocument() throws SAXException {
            this.schemaCheck();
            IntIterator rows = this.edges.rows();
            while (rows.hasNext()) {
                int rowIndex = rows.nextInt();
                String source = this.edges.getString(rowIndex, SOURCE_ID);
                if (!this.nodeIDsToRowNumbers.containsKey(source)) {
                    throw new SAXException("Tried to create edge with source node id = " + source + " which does not exist.");
                }
                int s = this.nodeIDsToRowNumbers.get(source);
                this.edges.setInt(rowIndex, SOURCE, s);
                String target = this.edges.getString(rowIndex, TARGET_ID);
                if (!this.nodeIDsToRowNumbers.containsKey(target)) {
                    throw new SAXException("Tried to create edge with target node this.idAttribute=" + target + " which does not exist.");
                }
                int t = this.nodeIDsToRowNumbers.get(target);
                this.edges.setInt(rowIndex, TARGET, t);
            }
            System.err.println("Node schema:");
            int ii = 0;
            while (ii < this.nodes.getColumnCount()) {
                System.err.println("\t" + this.nodes.getColumnName(ii) + ": " + this.nodes.getColumnType(ii));
                ++ii;
            }
            this.edges.removeColumn(SOURCE_ID);
            this.edges.removeColumn(TARGET_ID);
            this.graph = new Graph(this.nodes, this.edges, this.isDirected);
            if (this.graphID != null) {
                this.graph.putClientProperty("id", (Object)this.graphID);
            }
        }

        private String formNonConflictingNameForGUESS(String name, HashMap<String, Integer> hashMap, boolean showLog) {
            int count = 0;
            String modifiedName = name;
            if (hashMap.get(name) != null) {
                count = hashMap.get(name);
                modifiedName = String.valueOf(modifiedName) + count;
            } else if (DEFAULT_GUESS_NODES_ATTRIBUTES.contains(name) || DEFAULT_GUESS_EDGE_ATTRIBUTES.contains(name)) {
                modifiedName = String.valueOf(modifiedName) + count;
            }
            if (name != null && hashMap != null) {
                hashMap.put(name, new Integer(++count));
            }
            if (showLog && !name.equalsIgnoreCase(modifiedName)) {
                this.logger.log(2, String.valueOf(name) + "----->" + modifiedName);
            }
            return modifiedName;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String attributeName, Attributes attributes) throws SAXException {
            this.elementContents.delete(0, this.elementContents.length());
            if (attributeName.equals("graph")) {
                String edgeDefinition = attributes.getValue("edgedefault");
                this.isDirected = GUESS_ATTRIBUTE_DIRECTED.equalsIgnoreCase(edgeDefinition);
                this.graphID = attributes.getValue("id");
            } else if (attributeName.equals("key")) {
                if (!this.inSchema) {
                    throw new SAXException("\"key\" elements can not occur after the first node or edge declaration.");
                }
                this.forAttribute = attributes.getValue("for");
                this.idAttribute = attributes.getValue("id");
                this.nameAttribute = attributes.getValue("attr.name");
                if (this.cleanForGUESS) {
                    this.idAttribute = this.formNonConflictingNameForGUESS(this.idAttribute, this.attributeIdToCount, false);
                    this.nameAttribute = this.formNonConflictingNameForGUESS(this.nameAttribute, this.attributeNameToCount, true);
                }
                this.typeAttribute = attributes.getValue("attr.type");
            } else if (attributeName.equals("node")) {
                this.schemaCheck();
                this.nodeRow = this.nodes.addRow();
                String id = attributes.getValue("id");
                this.nodeIDsToRowNumbers.put(id, new Integer(this.nodeRow));
                this.currentTable = this.nodes;
            } else if (attributeName.equals("edge")) {
                this.schemaCheck();
                this.nodeRow = this.edges.addRow();
                this.edges.setString(this.nodeRow, SOURCE_ID, attributes.getValue(SOURCE));
                this.edges.setString(this.nodeRow, TARGET_ID, attributes.getValue(TARGET));
                this.currentTable = this.edges;
            } else if (attributeName.equals("data")) {
                this.currentKey = attributes.getValue("key");
                if (this.cleanForGUESS) {
                    this.currentKey = this.formNonConflictingNameForGUESS(this.currentKey, this.attributeKeyToCount, false);
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String attributeName) throws SAXException {
            if (attributeName.equals("default")) {
                this.defaultValue = this.elementContents.toString();
            } else if (attributeName.equals("key")) {
                this.addToSchema();
            } else if (attributeName.equals("data")) {
                String contents = this.elementContents.toString();
                String name = this.idToNameMap.get(this.currentKey);
                Class type = this.currentTable.getColumnType(name);
                try {
                    Object val = this.parse(contents, type);
                    this.currentTable.set(this.nodeRow, name, val);
                }
                catch (DataParseException e) {
                    throw new SAXException((Exception)((Object)e));
                }
            } else if ("node".equals(attributeName) || "edge".equals(attributeName)) {
                this.attributeKeyToCount.clear();
                this.nodeRow = -1;
                this.currentTable = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.elementContents.append(ch, start, length);
        }

        protected void schemaCheck() {
            if (this.inSchema) {
                this.nodeSchema.lockSchema();
                this.edgeSchema.lockSchema();
                this.nodes = this.nodeSchema.instantiate();
                this.edges = this.edgeSchema.instantiate();
                this.inSchema = false;
            }
        }

        protected void addToSchema() throws SAXException {
            if (this.nameAttribute == null || this.nameAttribute.length() == 0) {
                throw new SAXException("Empty key name.");
            }
            if (this.typeAttribute == null || this.typeAttribute.length() == 0) {
                throw new SAXException("Empty key type.");
            }
            try {
                Object defaultValue;
                Class<?> type = this.parseType(this.typeAttribute);
                Object object = defaultValue = this.defaultValue == null ? null : this.parse(this.defaultValue, type);
                if (this.forAttribute == null || this.forAttribute.equals("all")) {
                    this.addNodeColumn(type, defaultValue);
                    this.addEdgeColumn(type, defaultValue);
                } else if (this.forAttribute.equals("node")) {
                    this.addNodeColumn(type, defaultValue);
                } else if (this.forAttribute.equals("edge")) {
                    System.err.println(String.format("addColumn for edge: %s, %s, %s", this.nameAttribute, type, defaultValue));
                    System.err.println("\tedgeSchema:");
                    int ii = 0;
                    while (ii < this.edgeSchema.getColumnCount()) {
                        System.err.println(String.format("\t\t%s: %s", this.edgeSchema.getColumnName(ii), this.edgeSchema.getColumnType(ii).getName()));
                        ++ii;
                    }
                    this.addEdgeColumn(type, defaultValue);
                } else {
                    throw new SAXException("Unrecognized \"for\" value: " + this.forAttribute);
                }
                this.idToNameMap.put(this.idAttribute, this.nameAttribute);
                this.defaultValue = null;
            }
            catch (DataParseException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }

        private void addNodeColumn(Class<?> typeClazz, Object defaultValue) {
            this.addColumn(this.nodeSchema, typeClazz, defaultValue);
        }

        private void addEdgeColumn(Class<?> typeClazz, Object defaultValue) {
            this.addColumn(this.edgeSchema, typeClazz, defaultValue);
        }

        private void addColumn(Schema schema, Class<?> typeClazz, Object defaultValue) {
            boolean freshDeclaration = this.nodeSchema.getColumnIndex(this.nameAttribute) == -1;
            System.err.println(String.format("freshDeclaration: %s", freshDeclaration));
            boolean duplicateDeclarationAllowed = !NODE_ATTRIBUTES_TO_IGNORE_MULTIPLE_DECLARATIONS_OF.contains(this.nameAttribute);
            System.err.println(String.format("duplicateDeclarationAllowed: %s", duplicateDeclarationAllowed));
            if (freshDeclaration || !freshDeclaration && duplicateDeclarationAllowed) {
                schema.addColumn(this.nameAttribute, typeClazz, defaultValue);
            }
        }

        protected Class<?> parseType(String type) throws SAXException {
            if ((type = type.toLowerCase()).equals("int") || type.equals("integer")) {
                return Integer.TYPE;
            }
            if (type.equals("long")) {
                return Long.TYPE;
            }
            if (type.equals("float")) {
                return Float.TYPE;
            }
            if (type.equals("double") || type.equals("real")) {
                return Double.TYPE;
            }
            if (type.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (type.equals("string")) {
                return String.class;
            }
            if (type.equals("date")) {
                return Date.class;
            }
            throw new SAXException("Unrecognized data type: " + type);
        }

        protected Object parse(String input, Class<?> type) throws DataParseException {
            DataParser parser = this.parserFactory.getParser(type);
            return parser.parse(input);
        }

        public Graph getGraph() {
            return this.graph;
        }
    }

    public static interface Tokens {
        public static final String ID = "id";
        public static final String GRAPH = "graph";
        public static final String EDGE_DEFINITION = "edgedefault";
        public static final String DIRECTED = "directed";
        public static final String UNDIRECTED = "undirected";
        public static final String KEY = "key";
        public static final String FOR = "for";
        public static final String ALL = "all";
        public static final String ATTRIBUTE_NAME = "attr.name";
        public static final String ATTRIBUTE_TYPE = "attr.type";
        public static final String DEFAULT = "default";
        public static final String NODE = "node";
        public static final String EDGE = "edge";
        public static final String SOURCE = "source";
        public static final String TARGET = "target";
        public static final String DATA = "data";
        public static final String TYPE = "type";
        public static final String INT = "int";
        public static final String INTEGER = "integer";
        public static final String LONG = "long";
        public static final String FLOAT = "float";
        public static final String DOUBLE = "double";
        public static final String REAL = "real";
        public static final String BOOLEAN = "boolean";
        public static final String STRING = "string";
        public static final String DATE = "date";
    }
}

