/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusegraphml.reader;

import edu.iu.nwb.converter.prefusegraphml.reader.GraphMLReaderModified;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import prefuse.data.Graph;
import prefuse.data.io.DataIOException;

public class PrefuseGraphMLReader
implements Algorithm {
    private File inGraphMLFile;
    private boolean cleanForGUESS;
    private CIShellContext context;

    public PrefuseGraphMLReader(Data[] data, boolean cleanForGUESS, CIShellContext context) {
        this.inGraphMLFile = (File)data[0].getData();
        this.cleanForGUESS = cleanForGUESS;
        this.context = context;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            Graph outGraph = new GraphMLReaderModified(this.cleanForGUESS, this.context).readGraph(new FileInputStream(this.inGraphMLFile));
            return this.createOutData(this.inGraphMLFile, outGraph);
        }
        catch (DataIOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private Data[] createOutData(File inGraphMLFile, Graph outGraph) {
        BasicData outputData = new BasicData((Object)outGraph, Graph.class.getName());
        outputData.getMetadata().put("Label", "Prefuse Graph: " + inGraphMLFile);
        outputData.getMetadata().put("Type", "Network");
        return new Data[]{outputData};
    }
}

