/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusegraphml.reader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.UnicodeReader;

public class PrefuseGraphMLValidation
implements AlgorithmFactory {
    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        return new PrefuseGraphMLValidationAlgorithm(data);
    }

    public class PrefuseGraphMLValidationAlgorithm
    implements Algorithm {
        private Data[] inputData;
        private String inGraphMLFileName;

        public PrefuseGraphMLValidationAlgorithm(Data[] data) {
            this.inputData = data;
            this.inGraphMLFileName = (String)data[0].getData();
        }

        public Data[] execute() throws AlgorithmExecutionException {
            File inGraphMLFile = new File(this.inGraphMLFileName);
            try {
                if (this.validateGraphMLHeader(inGraphMLFile)) {
                    return this.createOutData(inGraphMLFile);
                }
                throw new AlgorithmExecutionException("Unable to validate GraphML file.");
            }
            catch (SecurityException e) {
                throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
            }
        }

        private Data[] createOutData(File inGraphMLFile) {
            BasicData outputData = new BasicData((Object)inGraphMLFile, "file:text/graphml+xml");
            String label = String.format("Prefuse GraphML file: %s", this.inGraphMLFileName);
            outputData.getMetadata().put("Label", label);
            outputData.getMetadata().put("Type", "Network");
            return new Data[]{outputData};
        }

        private boolean validateGraphMLHeader(File inData) throws FileNotFoundException, IOException {
            boolean hasGraphMLHeader = false;
            BufferedReader reader = new BufferedReader((Reader)new UnicodeReader((InputStream)new FileInputStream(inData)));
            String line = reader.readLine();
            while (line != null) {
                if (line.indexOf("http://graphml.graphdrawing.org/xmlns") != -1) {
                    hasGraphMLHeader = true;
                    break;
                }
                line = reader.readLine();
            }
            return hasGraphMLHeader;
        }
    }
}

