/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusegraphml.writer;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.io.AbstractGraphWriter;
import prefuse.data.io.DataIOException;
import prefuse.data.io.GraphMLReader;
import prefuse.util.io.XMLWriter;

public class GraphMLWriter
extends AbstractGraphWriter {
    private static final HashMap<Class<?>, String> TYPES = new HashMap();

    static {
        TYPES.put(Integer.TYPE, "int");
        TYPES.put(Integer.class, "int");
        TYPES.put(Long.TYPE, "long");
        TYPES.put(Long.class, "long");
        TYPES.put(Float.TYPE, "double");
        TYPES.put(Float.class, "double");
        TYPES.put(Double.TYPE, "double");
        TYPES.put(Double.class, "double");
        TYPES.put(Boolean.TYPE, "boolean");
        TYPES.put(Boolean.class, "boolean");
        TYPES.put(String.class, "string");
        TYPES.put(java.util.Date.class, "date");
        TYPES.put(Date.class, "date");
    }

    public void writeGraph(Graph graph, OutputStream output) throws DataIOException {
        boolean graphHasNodes = graph.nodes().hasNext();
        boolean graphHasEdges = graph.edges().hasNext();
        Schema nodeSchema = null;
        Schema edgeSchema = null;
        if (graphHasNodes) {
            nodeSchema = ((Node)graph.nodes().next()).getSchema();
            this.checkGraphMLSchema(nodeSchema);
        }
        if (graphHasEdges) {
            edgeSchema = ((Edge)graph.edges().next()).getSchema();
            this.checkGraphMLSchema(edgeSchema);
        }
        XMLWriter xml = null;
        try {
            xml = new XMLWriter(new PrintWriter(new OutputStreamWriter(output, "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            String message = "Error: The standard character encoding UTF-8 is not supported on this system.  Please report this to the development team.";
            throw new RuntimeException(message, e);
        }
        xml.begin("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns\n  http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n\n", 2);
        xml.comment("prefuse GraphML Writer | " + new java.util.Date(System.currentTimeMillis()));
        if (graphHasNodes) {
            this.printSchema(xml, "node", nodeSchema, null);
        }
        if (graphHasEdges) {
            this.printSchema(xml, "edge", edgeSchema, new String[]{graph.getEdgeSourceField(), graph.getEdgeTargetField()});
        }
        xml.println();
        String directed = graph.isDirected() ? "directed" : "undirected";
        xml.start("graph", "edgedefault", directed);
        if (graphHasNodes) {
            xml.comment("nodes");
            Iterator nodes = graph.nodes();
            while (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                if (nodeSchema.getColumnCount() > 0) {
                    xml.start("node", "id", "n" + String.valueOf(node.getRow()));
                    int ii = 0;
                    while (ii < nodeSchema.getColumnCount()) {
                        String field = nodeSchema.getColumnName(ii);
                        Object value = node.get(field);
                        if (value != null) {
                            xml.contentTag("data", "key", field.toLowerCase(), value.toString());
                        }
                        ++ii;
                    }
                    xml.end();
                    continue;
                }
                xml.tag("node", "id", "n" + String.valueOf(node.getRow()));
            }
        }
        xml.println();
        if (graphHasEdges) {
            String[] attributeNames = new String[]{"id", "source", "target"};
            String[] attributeValues = new String[3];
            xml.comment("edges");
            Iterator edges = graph.edges();
            while (edges.hasNext()) {
                Edge edge = (Edge)edges.next();
                attributeValues[0] = "e" + String.valueOf(edge.getRow());
                attributeValues[1] = "n" + String.valueOf(edge.getSourceNode().getRow());
                attributeValues[2] = "n" + String.valueOf(edge.getTargetNode().getRow());
                if (edgeSchema.getColumnCount() > 2) {
                    xml.start("edge", attributeNames, attributeValues, 3);
                    int ii = 0;
                    while (ii < edgeSchema.getColumnCount()) {
                        Object value;
                        String field = edgeSchema.getColumnName(ii);
                        if (!field.equals(graph.getEdgeSourceField()) && !field.equals(graph.getEdgeTargetField()) && (value = edge.get(field)) != null) {
                            xml.contentTag("data", "key", field.toLowerCase(), edge.get(field).toString());
                        }
                        ++ii;
                    }
                    xml.end();
                    continue;
                }
                xml.tag("edge", attributeNames, attributeValues, 3);
            }
        }
        xml.end();
        xml.finish("</graphml>\n");
    }

    private void printSchema(XMLWriter xml, String group, Schema s, String[] ignore) {
        String[] attr = new String[]{"id", "for", "attr.name", "attr.type"};
        String[] vals = new String[4];
        int i = 0;
        while (i < s.getColumnCount()) {
            block5: {
                vals[0] = s.getColumnName(i);
                int j = 0;
                while (ignore != null && j < ignore.length) {
                    if (!vals[0].equals(ignore[j])) {
                        ++j;
                        continue;
                    }
                    break block5;
                }
                vals[0] = vals[0].toLowerCase();
                vals[1] = group;
                vals[2] = vals[0];
                vals[3] = TYPES.get(s.getColumnType(i));
                Object dflt = s.getDefault(i);
                if (dflt == null) {
                    xml.tag("key", attr, vals, 4);
                } else {
                    xml.start("key", attr, vals, 4);
                    xml.contentTag("default", dflt.toString());
                    xml.end();
                }
            }
            ++i;
        }
    }

    private void checkGraphMLSchema(Schema s) throws DataIOException {
        int i = 0;
        while (i < s.getColumnCount()) {
            Class type = s.getColumnType(i);
            if (TYPES.get(type) == null) {
                throw new DataIOException("Data type unsupported by the GraphML format: " + type.getName());
            }
            ++i;
        }
    }

    public static interface Tokens
    extends GraphMLReader.Tokens {
        public static final String GRAPHML = "graphml";
        public static final String GRAPHML_HEADER = "<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns\n  http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n\n";
    }
}

