/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefuseisi.reader;

import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.Data;
import org.cishell.utilities.AlgorithmUtilities;

public class PrefuseCustomISIValidationAlgorithm
implements Algorithm {
    private Dictionary<String, Object> parameters;
    private CIShellContext ciShellContext;
    private AlgorithmFactory isiPrefuseValidator;
    private AlgorithmFactory isiToPrefuseConverter;
    private AlgorithmFactory isiDupRemover;
    private Data[] data;

    public PrefuseCustomISIValidationAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext context, AlgorithmFactory isiPrefuseValidator, AlgorithmFactory isiToPrefuseConverter, AlgorithmFactory isiDupRemover) {
        this.data = data;
        this.parameters = parameters;
        this.ciShellContext = context;
        this.isiPrefuseValidator = isiPrefuseValidator;
        this.isiToPrefuseConverter = isiToPrefuseConverter;
        this.isiDupRemover = isiDupRemover;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        if (this.data == null || this.data.length == 0) {
            return new Data[0];
        }
        Data[] validatorData = AlgorithmUtilities.executeAlgorithm((AlgorithmFactory)this.isiPrefuseValidator, (Data[])this.data, this.parameters, (CIShellContext)this.ciShellContext);
        Data[] convertedToPrefuseData = AlgorithmUtilities.executeAlgorithm((AlgorithmFactory)this.isiToPrefuseConverter, (Data[])validatorData, this.parameters, (CIShellContext)this.ciShellContext);
        Data[] duplicatesRemovedData = AlgorithmUtilities.executeAlgorithm((AlgorithmFactory)this.isiDupRemover, (Data[])convertedToPrefuseData, this.parameters, (CIShellContext)this.ciShellContext);
        Data[] originalAndDuplicatesRemovedData = new Data[]{convertedToPrefuseData[0], duplicatesRemovedData[0]};
        return originalAndDuplicatesRemovedData;
    }
}

