/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefuseisi.reader;

import edu.iu.nwb.converter.prefuseisi.reader.PrefuseCustomISIValidationAlgorithm;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.Data;
import org.cishell.utilities.AlgorithmUtilities;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;

public class PrefuseCustomISIValidationFactory
implements AlgorithmFactory {
    private BundleContext bundleContext;
    private LogService logger;

    protected void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
        this.logger = (LogService)componentContext.locateService("LOG");
    }

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        AlgorithmFactory isiPrefuseValidator = PrefuseCustomISIValidationFactory.getPrefuseIsiValidation(this.bundleContext, this.logger);
        AlgorithmFactory isiToPrefuseConverter = PrefuseCustomISIValidationFactory.getISIToPrefuseConverter(this.bundleContext, this.logger);
        AlgorithmFactory isiDuplicateRemover = PrefuseCustomISIValidationFactory.getISIDuplicateRemover(this.bundleContext, this.logger);
        return new PrefuseCustomISIValidationAlgorithm(data, parameters, ciShellContext, isiPrefuseValidator, isiToPrefuseConverter, isiDuplicateRemover);
    }

    private static AlgorithmFactory getPrefuseIsiValidation(BundleContext bundleContext, LogService logger) {
        return AlgorithmUtilities.getAlgorithmFactoryByPID((String)"edu.iu.nwb.converter.prefuseisi.reader.PrefuseIsiValidation", (BundleContext)bundleContext);
    }

    private static AlgorithmFactory getISIToPrefuseConverter(BundleContext bundleContext, LogService logger) {
        String isiToPrefuseConverterFilter = "(& (in_data=file:text/isi) (out_data=prefuse.data.Table))";
        return AlgorithmUtilities.getAlgorithmFactoryByFilter((String)isiToPrefuseConverterFilter, (BundleContext)bundleContext);
    }

    private static AlgorithmFactory getISIDuplicateRemover(BundleContext bundleContext, LogService logger) {
        return AlgorithmUtilities.getAlgorithmFactoryByPID((String)"edu.iu.nwb.analysis.isidupremover.ISIDupRemoverAlgorithm", (BundleContext)bundleContext);
    }
}

