/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefuseisi.reader;

import edu.iu.nwb.shared.isiutil.ISITableReaderHelper;
import edu.iu.nwb.shared.isiutil.exception.ReadISIFileException;
import java.io.File;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class PrefuseIsiReader
implements Algorithm {
    public static final boolean SHOULD_NORMALIZE_AUTHOR_NAMES = true;
    public static final boolean SHOULD_CLEAN_AUTHOR_NAME_CAPITALIZATIONS = true;
    public static final boolean SHOULD_FILL_FILE_METADATA = false;
    public static final boolean SHOULD_CLEAN_CITED_REFERENCES = true;
    private File inISIFile;
    private LogService logger;

    public PrefuseIsiReader(Data[] data, CIShellContext context) {
        this.inISIFile = (File)data[0].getData();
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            return this.createOutData(ISITableReaderHelper.readISIFile((File)this.inISIFile, (LogService)this.logger, (boolean)true, (boolean)true, (boolean)false, (boolean)true));
        }
        catch (ReadISIFileException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private Data[] createOutData(Table preparedTable) {
        Data[] tableToReturnData = new Data[]{new BasicData((Object)preparedTable, Table.class.getName())};
        tableToReturnData[0].getMetadata().put("Label", "ISI Data: " + this.inISIFile);
        tableToReturnData[0].getMetadata().put("Type", "Table");
        return tableToReturnData;
    }
}

