/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefuseisi.reader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.UnicodeReader;

public class PrefuseIsiValidation
implements AlgorithmFactory {
    public static final Pattern ISI_FIRST_TAG = Pattern.compile("fn .*", 98);
    public static final int NUMBER_LINES_CONSIDERED = 5;

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
        return new ISIValidationAlgorithm(data);
    }

    static boolean lineMatchesSignature(String line) {
        return ISI_FIRST_TAG.matcher(line).matches();
    }

    public class ISIValidationAlgorithm
    implements Algorithm {
        public static final String ISI_MIME_TYPE = "file:text/isi";
        private String inISIFileName;

        public ISIValidationAlgorithm(Data[] data) {
            this.inISIFileName = (String)data[0].getData();
        }

        public Data[] execute() throws AlgorithmExecutionException {
            File inputFile = new File(this.inISIFileName);
            if (this.fileHasISISignature(inputFile, 5)) {
                return this.createOutData(inputFile);
            }
            throw new AlgorithmExecutionException("Invalid ISI format file selected.  Unable to continue loading " + this.inISIFileName + " file.");
        }

        private boolean fileHasISISignature(File inputFile, int numLines) throws AlgorithmExecutionException {
            List<String> initialLines = this.readInitialLines(inputFile, numLines);
            for (String line : initialLines) {
                if (!PrefuseIsiValidation.lineMatchesSignature(line)) continue;
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private List<String> readInitialLines(File inFile, int numLines) throws AlgorithmExecutionException {
            BufferedReader inReader = null;
            LinkedList<String> firstLines = new LinkedList<String>();
            int currentNumberOfLinesCounter = 0;
            try {
                try {
                    inReader = new BufferedReader((Reader)new UnicodeReader((InputStream)new FileInputStream(inFile)));
                    while (true) {
                        String lineContent = inReader.readLine();
                        if (lineContent == null) return firstLines;
                        if (currentNumberOfLinesCounter >= numLines) {
                            return firstLines;
                        }
                        if ((lineContent = lineContent.trim()).isEmpty()) continue;
                        firstLines.add(lineContent);
                        ++currentNumberOfLinesCounter;
                    }
                }
                catch (IOException e) {
                    throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                try {
                    inReader.close();
                }
                catch (IOException e) {
                    throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
                }
            }
        }

        private Data[] createOutData(File inputData) {
            Data[] validationData = new Data[]{new BasicData((Object)inputData, ISI_MIME_TYPE)};
            validationData[0].getMetadata().put("Label", "Prefuse ISI file: " + this.inISIFileName);
            validationData[0].getMetadata().put("Type", "Table");
            return validationData;
        }
    }
}

