/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefuseisi.writer;

import java.io.File;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;

public class PrefuseCsvFileHandler
implements AlgorithmFactory {
    public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        return new PrefuseGraphMLFileHandlerAlg(data);
    }

    public class PrefuseGraphMLFileHandlerAlg
    implements Algorithm {
        public static final String CSV_MIME_TYPE = "file:text/csv";
        public static final String CSV_FILE_EXT = "file-ext:csv";
        private Object inData;
        private String inFormat;

        public PrefuseGraphMLFileHandlerAlg(Data[] data) {
            this.inData = data[0].getData();
            this.inFormat = data[0].getFormat();
        }

        public Data[] execute() throws AlgorithmExecutionException {
            if (this.inData instanceof File) {
                if (this.inFormat.equals(CSV_MIME_TYPE)) {
                    return new Data[]{new BasicData(this.inData, CSV_FILE_EXT)};
                }
                throw new AlgorithmExecutionException("Expected file:text/csv, but the input format is " + this.inFormat);
            }
            throw new AlgorithmExecutionException("Expected a file, but the input data is of type " + this.inData.getClass().getName());
        }
    }
}

