/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusensf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.service.conversion.ConversionException;
import org.cishell.service.conversion.DataConversionService;
import org.cishell.utilities.UnicodeReader;
import org.osgi.service.log.LogService;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.column.Column;

public class NSFReaderAlgorithm
implements Algorithm {
    public static final String CSV_MIME_TYPE = "file:text/csv";
    public static final int READ_AHEAD_LIMIT = 2;
    public static final String OLD_VERSION_FIRST_HEADER = "Award Number";
    private boolean isOldNsfFormat = false;
    private String inputNameSeparator = ",";
    private String outputNameSeparator = ",";
    private String primaryPiColumnName = "PrincipalInvestigator";
    private String coPiColumnName = "Co-PIName(s)";
    private String allPiColumnName = "AllInvestigators";
    private String awardNumberColumnName = "AwardNumber";
    private String awardedToDateColumnName = "AwardedAmountToDate";
    private String arraAmountColumnName = "ARRAAmount";
    private Data[] data;
    private LogService log;
    private DataConversionService conversionService;

    public NSFReaderAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.log = (LogService)context.getService(LogService.class.getName());
        this.conversionService = (DataConversionService)context.getService(DataConversionService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Data inputTableData = this.convertInputData(this.data[0]);
        Table inputTable = (Table)inputTableData.getData();
        Table copiedTable = this.copyAndNormalizeTable(inputTable);
        copiedTable = this.normalizeCoPIs(copiedTable);
        copiedTable = this.addPIColumn(copiedTable);
        if (this.isOldNsfFormat) {
            copiedTable = this.normalizePrimaryPIs(copiedTable);
        }
        return this.createOutData(this.data[0], copiedTable);
    }

    private Table copyAndNormalizeTable(Table inputTable) {
        Table returnTable = new Table();
        Schema oldSchema = inputTable.getSchema();
        int numTableColumns = oldSchema.getColumnCount();
        int numTableRows = inputTable.getRowCount();
        returnTable.addRows(numTableRows);
        int col = 0;
        while (col < numTableColumns) {
            String colHead = oldSchema.getColumnName(col);
            Class<Float> currentColumnType = oldSchema.getColumnType(col);
            if (!this.isOldNsfFormat && (colHead.equals(this.awardedToDateColumnName) || colHead.equals(this.arraAmountColumnName))) {
                currentColumnType = Float.class;
            }
            returnTable.addColumn(colHead, (Class)currentColumnType);
            int row = 0;
            while (row < numTableRows) {
                Object currentCellValue = inputTable.get(row, col);
                if (!this.isOldNsfFormat && (colHead.equals(this.awardedToDateColumnName) || colHead.equals(this.arraAmountColumnName)) && currentCellValue instanceof String) {
                    currentCellValue = Float.valueOf(this.normalizeDollarAmountString((String)currentCellValue));
                }
                returnTable.set(row, col, currentCellValue);
                ++row;
            }
            ++col;
        }
        return returnTable;
    }

    private float normalizeDollarAmountString(String origValue) {
        if (origValue.length() < 5) {
            return 0.0f;
        }
        String normalizedContents = origValue.replaceAll("[^a-zA-Z0-9.]", "");
        try {
            return Float.parseFloat(normalizedContents);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log(2, "Invalid data found in column containing dollar amounts: \"" + origValue + "\". Assuming value of $0 for this row.");
            return 0.0f;
        }
    }

    private Table normalizeCoPIs(Table nsfTable) {
        Column coPIColumn = nsfTable.getColumn(this.coPiColumnName);
        int rowIndex = 0;
        while (rowIndex < nsfTable.getRowCount()) {
            String contents = coPIColumn.getString(rowIndex);
            if (contents != null && !contents.equals("")) {
                String[] coPINames = contents.split("\\" + this.inputNameSeparator);
                String[] normalizedCOPINames = new String[coPINames.length];
                int coPIIndex = 0;
                while (coPIIndex < coPINames.length) {
                    String normalizedName;
                    String coPIName = coPINames[coPIIndex];
                    normalizedCOPINames[coPIIndex] = normalizedName = this.normalizeCOPIName(coPIName);
                    ++coPIIndex;
                }
                String normalizedContents = this.join(normalizedCOPINames, this.outputNameSeparator);
                coPIColumn.setString(normalizedContents, rowIndex);
            }
            ++rowIndex;
        }
        return nsfTable;
    }

    private Table normalizePrimaryPIs(Table nsfTable) {
        Column coPIColumn = nsfTable.getColumn(this.primaryPiColumnName);
        int rowIndex = 0;
        while (rowIndex < nsfTable.getRowCount()) {
            String primaryPIName = coPIColumn.getString(rowIndex);
            if (primaryPIName != null && !primaryPIName.equals("")) {
                String normalizedPIName = this.normalizePrimaryPIName(primaryPIName);
                coPIColumn.setString(normalizedPIName, rowIndex);
            }
            ++rowIndex;
        }
        return nsfTable;
    }

    private Table addPIColumn(Table normalizedNSFTable) {
        normalizedNSFTable.addColumn(this.allPiColumnName, String.class);
        Column allPIColumn = normalizedNSFTable.getColumn(this.allPiColumnName);
        Column primaryPIColumn = normalizedNSFTable.getColumn(this.primaryPiColumnName);
        Column coPIColumn = normalizedNSFTable.getColumn(this.coPiColumnName);
        int rowIndex = 0;
        while (rowIndex < normalizedNSFTable.getRowCount()) {
            String primaryPI = primaryPIColumn.getString(rowIndex);
            String coPIs = coPIColumn.getString(rowIndex);
            String allPIs = null;
            if (primaryPI != null && coPIs != null) {
                allPIs = String.valueOf(primaryPI) + this.outputNameSeparator + coPIs;
            } else if (primaryPI == null && coPIs == null) {
                allPIs = "";
            } else if (primaryPI == null) {
                allPIs = coPIs;
            } else if (coPIs == null) {
                allPIs = primaryPI;
            }
            allPIColumn.setString(allPIs, rowIndex);
            ++rowIndex;
        }
        return normalizedNSFTable;
    }

    private Data[] createOutData(Data originalData, Table normalizedNSFTable) throws AlgorithmExecutionException {
        try {
            Data[] dm = new Data[]{new BasicData((Object)normalizedNSFTable, "prefuse.data.Table")};
            dm[0].getMetadata().put("Label", "Normalized NSF table");
            dm[0].getMetadata().put("Type", "Table");
            dm[0].getMetadata().put("Parent", originalData);
            return dm;
        }
        catch (SecurityException e) {
            throw new AlgorithmExecutionException((Throwable)e);
        }
    }

    private String normalizeCOPIName(String coPIName) {
        String oneOrMoreWhitespaces = "[\\s]+";
        String normalizedCoPIName = coPIName.replaceAll(oneOrMoreWhitespaces, " ").trim();
        return normalizedCoPIName;
    }

    private String normalizePrimaryPIName(String primaryPIName) {
        int lastCommaIndex = primaryPIName.lastIndexOf(",");
        if (lastCommaIndex == -1) {
            this.printUnexpectedPrimaryPINameWarning(primaryPIName);
            return primaryPIName;
        }
        String beforeComma = primaryPIName.substring(0, lastCommaIndex).trim();
        String afterComma = primaryPIName.substring(lastCommaIndex + 1).trim();
        String normalizedPrimaryPIName = String.valueOf(afterComma) + " " + beforeComma;
        return normalizedPrimaryPIName;
    }

    private void printUnexpectedPrimaryPINameWarning(String primaryPIName) {
        this.log.log(2, "Expected to find a comma separating last name from first name in the primary investigator name '" + primaryPIName + "'. \r\n " + " We will not normalize this name, and will instead leave it as it is.");
    }

    private String join(String[] tokens, String separator) {
        StringBuffer joinedTokens = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            joinedTokens.append(tokens[i]);
            if (i < tokens.length - 1) {
                joinedTokens.append(separator);
            }
            ++i;
        }
        return joinedTokens.toString();
    }

    private Data convertInputData(Data inputData) throws AlgorithmExecutionException {
        Dictionary metadata = inputData.getMetadata();
        BasicData formatChangedData = new BasicData(metadata, (Object)this.cleanNSFCSVFormat((File)inputData.getData()), CSV_MIME_TYPE);
        try {
            Data convertedData = this.conversionService.convert((Data)formatChangedData, "prefuse.data.Table");
            if (!(convertedData.getData() instanceof Table)) {
                throw new ConversionException("Output of conversion was not a prefuse.data.Table");
            }
            return convertedData;
        }
        catch (ConversionException e) {
            throw new AlgorithmExecutionException("Could not convert format to prefuse.data.Table", (Throwable)e);
        }
    }

    private File cleanNSFCSVFormat(File escapedQuoteFile) throws AlgorithmExecutionException {
        BufferedReader in = null;
        PrintWriter out = null;
        try {
            int c;
            FileInputStream stream = new FileInputStream(escapedQuoteFile);
            in = new BufferedReader((Reader)new UnicodeReader((InputStream)stream));
            File outFile = File.createTempFile("cleanedNSFCSV", "csv");
            out = new PrintWriter(outFile, "UTF-8");
            String headerLine = in.readLine();
            if (headerLine != null) {
                if (headerLine.indexOf(OLD_VERSION_FIRST_HEADER) != -1) {
                    this.isOldNsfFormat = true;
                    this.log.log(2, "Old version NSF file format detected. Use | delimiter and \"-pre2014\" version aggregation function files when executing algorithms on this file.");
                    this.inputNameSeparator = "|";
                    this.outputNameSeparator = "|";
                    this.primaryPiColumnName = "Principal Investigator";
                    this.coPiColumnName = "Co-PI Name(s)";
                    this.allPiColumnName = "All Investigators";
                    this.awardNumberColumnName = OLD_VERSION_FIRST_HEADER;
                    this.awardedToDateColumnName = "Awarded Amount To Date";
                    this.arraAmountColumnName = "ARRA Amount";
                } else {
                    this.log.log(2, "New version NSF file format detected. Use , delimiter and current version aggregation function files when executing algorithms on this file.");
                }
                if (this.hasTwoAwardNumberColumns(headerLine)) {
                    headerLine = this.renameDuplicateAwardNumberColumn(headerLine);
                }
                out.write(String.valueOf(headerLine) + "\r\n");
            }
            while ((c = in.read()) != -1) {
                int nextC;
                if (c == 92) {
                    in.mark(2);
                    nextC = in.read();
                    if (nextC == 34) {
                        out.write(34);
                    }
                    in.reset();
                    continue;
                }
                if (c == 13) {
                    in.mark(2);
                    nextC = in.read();
                    if (nextC == 10) {
                        out.write(13);
                    }
                    in.reset();
                    continue;
                }
                out.write((char)c);
            }
            File file = outFile;
            return file;
        }
        catch (FileNotFoundException e) {
            this.log.log(2, "NSFReader could not find a file at " + escapedQuoteFile.getAbsolutePath(), (Throwable)e);
            File file = escapedQuoteFile;
            return file;
        }
        catch (IOException e) {
            this.log.log(2, "Unable to remove slash escaped quotes from nsf csv file due to IO Exception", (Throwable)e);
            File file = escapedQuoteFile;
            return file;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException e) {
                throw new AlgorithmExecutionException("Could not close file: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean hasTwoAwardNumberColumns(String headerLine) {
        return headerLine.indexOf(this.awardNumberColumnName) != headerLine.lastIndexOf(this.awardNumberColumnName);
    }

    private String renameDuplicateAwardNumberColumn(String line) {
        return line.replaceAll(this.awardNumberColumnName, String.valueOf(this.awardNumberColumnName) + " Duplicate").replaceFirst(String.valueOf(this.awardNumberColumnName) + " Duplicate", this.awardNumberColumnName);
    }
}

