/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusensf;

import java.io.File;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;

public class NSFValidatorAlgorithm
implements Algorithm {
    private String inNSFFileName;

    public NSFValidatorAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.inNSFFileName = (String)data[0].getData();
    }

    public Data[] execute() throws AlgorithmExecutionException {
        File inNSFFile = new File(this.inNSFFileName);
        try {
            return this.createOutData(inNSFFile);
        }
        catch (SecurityException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private Data[] createOutData(File nsfFile) {
        Data[] validatedData = new Data[]{new BasicData((Object)nsfFile, "file:text/nsf")};
        validatedData[0].getMetadata().put("Label", "NSF csv file: " + this.inNSFFileName);
        validatedData[0].getMetadata().put("Type", "Table");
        return validatedData;
    }
}

