package edu.iu.nwb.converter.prefusescopus;

import java.util.Dictionary;

import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.Data;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.MetaTypeService;


public class ScopusValidatorAlgorithmFactory implements AlgorithmFactory {
    private MetaTypeProvider provider;

    
    protected void activate(ComponentContext ctxt) {
        /* You may delete all references to metatype service if
         * your algorithm does not require parameters and return
         * null in the createParameters() method
         */
        MetaTypeService mts = (MetaTypeService)ctxt.locateService("MTS");
        provider =
        	mts.getMetaTypeInformation(ctxt.getBundleContext().getBundle());       
    }
    protected void deactivate(ComponentContext ctxt) {
        provider = null;
    }

    public Algorithm createAlgorithm(
    		Data[] data, Dictionary parameters, CIShellContext context) {
        return new ScopusValidatorAlgorithm(data, parameters, context);
    }
    
    public MetaTypeProvider createParameters(Data[] data) {
        return provider;
    }
}