/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusescopus;

import edu.iu.nwb.converter.prefusescopus.util.TableCleaner;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.service.conversion.ConversionException;
import org.cishell.service.conversion.DataConversionService;
import org.cishell.utilities.FileUtilities;
import org.cishell.utilities.TableUtilities;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class ScopusReaderAlgorithm
implements Algorithm {
    public static final String CSV_MIME_TYPE = "file:text/csv";
    Data[] data;
    CIShellContext context;
    LogService log;

    public ScopusReaderAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.context = context;
        this.log = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Data inputData = this.convertInputData(this.data[0]);
        Table scopusTable = (Table)inputData.getData();
        TableCleaner cleaner = new TableCleaner(this.log);
        scopusTable = cleaner.cleanTable(scopusTable);
        URL configPath = FileUtilities.lookupResourceUrl(ScopusReaderAlgorithm.class, (String)"scopus.hmap");
        Table finalTable = null;
        try {
            finalTable = TableUtilities.standardizeTable((URL)configPath, (Table)scopusTable);
        }
        catch (IOException iOException) {
            String errorMsg = "An error has occurred while attempting to read the Scopus format file. Please contact cns-sci2-help-l@iulist.indiana.edu for assistance.";
            throw new AlgorithmExecutionException(errorMsg);
        }
        Data[] outputData = this.formatAsData(finalTable);
        return outputData;
    }

    private Data convertInputData(Data inputData) throws AlgorithmExecutionException {
        DataConversionService converter = (DataConversionService)this.context.getService(DataConversionService.class.getName());
        BasicData formatChangedData = new BasicData(inputData.getMetadata(), (Object)((File)inputData.getData()), CSV_MIME_TYPE);
        try {
            Data convertedData = converter.convert((Data)formatChangedData, Table.class.getName());
            return convertedData;
        }
        catch (ConversionException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private Data[] formatAsData(Table scopusTable) throws AlgorithmExecutionException {
        try {
            Data[] dm = new Data[]{new BasicData((Object)scopusTable, Table.class.getName())};
            dm[0].getMetadata().put("Label", "Normalized Scopus table");
            dm[0].getMetadata().put("Type", "Table");
            return dm;
        }
        catch (SecurityException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }
}

