/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusescopus;

import edu.iu.nwb.converter.prefusecsv.validator.PrefuseCsvValidator;
import java.io.File;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;

public class ScopusValidatorAlgorithm
implements Algorithm {
    public static final String SCOPUS_MIME_TYPE = "file:text/scopus";
    private String inScopusFileName;

    public ScopusValidatorAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.inScopusFileName = (String)data[0].getData();
    }

    public Data[] execute() throws AlgorithmExecutionException {
        File inScopusFile = new File(this.inScopusFileName);
        try {
            PrefuseCsvValidator csvValidator = new PrefuseCsvValidator();
            csvValidator.validateSelectedFileforCSVFormat(this.inScopusFileName);
            return this.createOutData(inScopusFile);
        }
        catch (SecurityException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private Data[] createOutData(File inData) {
        Data[] validationData = new Data[]{new BasicData((Object)inData, SCOPUS_MIME_TYPE)};
        validationData[0].getMetadata().put("Label", "Scopus csv file: " + this.inScopusFileName);
        validationData[0].getMetadata().put("Type", "Matrix");
        return validationData;
    }
}

