/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusescopus.util;

import edu.iu.nwb.converter.prefusescopus.util.StringUtil;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.utilities.TableUtilities;
import org.osgi.service.log.LogService;
import prefuse.data.DataTypeException;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.column.Column;
import prefuse.util.collections.IntIterator;

public class TableCleaner {
    private static final String AUTHOR_COLUMN_NAME = "Authors";
    private static final String ORIG_AUTHOR_COLUMN_NAME_SEPARATOR = ", ";
    private static final String NEW_AUTHOR_COLUMN_NAME_SEPARATOR = "|";
    private static final String REFERENCE_COLUMN_NAME = "References";
    private static final String ORIG_REFERENCE_COLUMN_NAME_SEPARATOR = "; ";
    private static final String NEW_REFERENCE_COLUMN_NAME_SEPARATOR = "|";
    private static final String SELF_REFERENCE_COLUMN_NAME = "Self Reference";
    private static final String AUTHORS_COLUMN_NAME = "Authors";
    private static final String TITLE_COLUMN_NAME = "Title";
    private static final String YEAR_COLUMN_NAME = "Year";
    private static final String SOURCE_TITLE_COLUMN_NAME = "Source title";
    private static final String VOLUME_COLUMN_NAME = "Volume";
    private LogService log;
    private static final String ISSUE_COLUMN_NAME = "Issue";
    private static final String PAGE_START_COLUMN_NAME = "Page start";
    private static final String PAGE_END_COLUMN_NAME = "Page end";

    public TableCleaner(LogService log) {
        this.log = log;
    }

    private Table addSelfReferences(Table scopusTable) throws AlgorithmExecutionException {
        scopusTable.addColumn(SELF_REFERENCE_COLUMN_NAME, String.class);
        IntIterator tableIt = scopusTable.rows();
        while (tableIt.hasNext()) {
            int rowIndex = tableIt.nextInt();
            Tuple row = scopusTable.getTuple(rowIndex);
            String selfReference = this.createSelfReference(row);
            scopusTable.setString(rowIndex, SELF_REFERENCE_COLUMN_NAME, selfReference);
        }
        return scopusTable;
    }

    public Table cleanTable(Table scopusTableIn) throws AlgorithmExecutionException {
        scopusTableIn = this.fixBotchedUnicodeImport(scopusTableIn);
        Table scopusTable = this.normalizeAuthorNames(scopusTableIn);
        scopusTable = this.normalizeReferences(scopusTable);
        return this.addSelfReferences(scopusTable);
    }

    private Table fixBotchedUnicodeImport(Table in) {
        Table returnTable = new Table();
        Schema oldSchema = in.getSchema();
        int numTableColumns = oldSchema.getColumnCount();
        int numTableRows = in.getRowCount();
        int i = 0;
        while (i < numTableColumns) {
            String colHead = oldSchema.getColumnName(i);
            if (i == 0) {
                colHead = "Authors";
            }
            returnTable.addColumn(colHead, oldSchema.getColumnType(i));
            ++i;
        }
        returnTable.addRows(numTableRows);
        i = 0;
        while (i < numTableRows) {
            TableUtilities.copyTableRow((int)i, (int)i, (Table)returnTable, (Table)in);
            ++i;
        }
        return returnTable;
    }

    private Table normalizeAuthorNames(Table scopusTable) {
        Column authorColumn = scopusTable.getColumn("Authors");
        if (authorColumn == null) {
            this.printNoAuthorColumnWarning();
            return scopusTable;
        }
        try {
            IntIterator tableIt = scopusTable.rows();
            while (tableIt.hasNext()) {
                int rowIndex = tableIt.nextInt();
                String authors = authorColumn.getString(rowIndex);
                if (authors == null || authors.equals("")) continue;
                String normalizedAuthors = this.normalizeAuthorNames(authors);
                authorColumn.setString(normalizedAuthors, rowIndex);
            }
        }
        catch (DataTypeException e) {
            this.printColumnNotOfTypeStringWarning(e);
            return scopusTable;
        }
        return scopusTable;
    }

    private String normalizeAuthorNames(String authorNames) {
        String[] eachAuthorName = authorNames.split(ORIG_AUTHOR_COLUMN_NAME_SEPARATOR);
        String normalizedAuthorNames = StringUtil.join(eachAuthorName, "|");
        return normalizedAuthorNames;
    }

    private Table normalizeReferences(Table scopusTable) {
        Column referenceColumn = scopusTable.getColumn(REFERENCE_COLUMN_NAME);
        if (referenceColumn == null) {
            this.printNoReferenceColumnWarning();
            return scopusTable;
        }
        try {
            IntIterator tableIt = scopusTable.rows();
            while (tableIt.hasNext()) {
                int rowIndex = tableIt.nextInt();
                String references = referenceColumn.getString(rowIndex);
                if (references == null || references.equals("")) continue;
                String normalizedReferences = this.normalizeReferences(references);
                referenceColumn.setString(normalizedReferences, rowIndex);
            }
        }
        catch (DataTypeException e) {
            this.printColumnNotOfTypeStringWarning(e);
            return scopusTable;
        }
        return scopusTable;
    }

    private String normalizeReferences(String references) {
        String[] eachReference = references.split(ORIG_REFERENCE_COLUMN_NAME_SEPARATOR);
        String normalizedReferences = StringUtil.join(eachReference, "|");
        return normalizedReferences;
    }

    private String createSelfReference(Tuple isiRow) throws AlgorithmExecutionException {
        String title;
        StringBuffer selfReference;
        block12: {
            String authors;
            block11: {
                selfReference = new StringBuffer();
                authors = this.extractAuthors(isiRow);
                if (authors != null) break block11;
                this.printNoAuthorColumnWarning();
                return "";
            }
            selfReference.append(authors);
            selfReference.append(ORIG_AUTHOR_COLUMN_NAME_SEPARATOR);
            title = this.extractTitle(isiRow);
            if (title != null) break block12;
            this.printNoTitleColumnWarning();
            return "";
        }
        try {
            String pageEnd;
            String pageStart;
            String issue;
            String volume;
            String sourceTitle;
            selfReference.append(title);
            selfReference.append(" ");
            String year = this.extractYear(isiRow);
            if (year != null) {
                selfReference.append(" (");
                selfReference.append(year);
                selfReference.append(")");
            }
            if ((sourceTitle = this.extractSourceTitle(isiRow)) != null) {
                selfReference.append(" ");
                selfReference.append(sourceTitle);
            }
            if ((volume = this.extractVolume(isiRow)) != null) {
                selfReference.append(ORIG_AUTHOR_COLUMN_NAME_SEPARATOR);
                selfReference.append(volume);
            }
            if ((issue = this.extractIssue(isiRow)) != null) {
                selfReference.append(" (");
                selfReference.append(issue);
                selfReference.append(")");
            }
            if ((pageStart = this.extractPageStart(isiRow)) != null) {
                selfReference.append(", pp. ");
                selfReference.append(pageStart);
            }
            if ((pageEnd = this.extractPageEnd(isiRow)) != null) {
                selfReference.append("-");
                selfReference.append(pageEnd);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (DataTypeException e) {
            throw new AlgorithmExecutionException("Some elements in the tuple '" + isiRow + "' cannot be converted to a String (apparently)", (Throwable)e);
        }
        return selfReference.toString();
    }

    private String extractPageEnd(Tuple isiRow) {
        return this.trimBrackets(isiRow.getString(PAGE_END_COLUMN_NAME));
    }

    private String extractPageStart(Tuple isiRow) {
        return this.trimBrackets(isiRow.getString(PAGE_START_COLUMN_NAME));
    }

    private String extractIssue(Tuple isiRow) {
        return this.trimBrackets(isiRow.getString(ISSUE_COLUMN_NAME));
    }

    private String extractVolume(Tuple isiRow) {
        return isiRow.getString(VOLUME_COLUMN_NAME);
    }

    private String extractSourceTitle(Tuple isiRow) {
        return isiRow.getString(SOURCE_TITLE_COLUMN_NAME);
    }

    private String extractYear(Tuple isiRow) {
        return isiRow.getString(YEAR_COLUMN_NAME);
    }

    private String extractTitle(Tuple isiRow) {
        return isiRow.getString(TITLE_COLUMN_NAME);
    }

    private String extractAuthors(Tuple isiRow) {
        String authorsWithNewSeparator = isiRow.getString("Authors");
        String[] eachAuthor = authorsWithNewSeparator.split("\\|");
        String authorsWithOriginalSeparator = StringUtil.join(eachAuthor, ORIG_AUTHOR_COLUMN_NAME_SEPARATOR);
        return authorsWithOriginalSeparator;
    }

    private String trimBrackets(String s) {
        if (s == null) {
            return null;
        }
        String tempS = s;
        if (tempS.startsWith("[")) {
            tempS = tempS.substring(1);
        }
        if (tempS.endsWith("]")) {
            tempS = tempS.substring(0, tempS.length() - 1);
        }
        String result = tempS;
        return result;
    }

    private void printNoAuthorColumnWarning() {
        this.log.log(2, "Unable to find column with the name 'Authors' in scopus file. We will continue on without attempting to normalize this column");
    }

    private void printNoReferenceColumnWarning() {
        this.log.log(2, "Unable to find column with the name 'References' in scopus file. We will continue on without attempting to normalize this column");
    }

    private void printNoTitleColumnWarning() {
        this.log.log(2, "Unable to find column with the name 'Title' in scopus file. We will continue on without attempting to normalize this column");
    }

    private void printColumnNotOfTypeStringWarning(DataTypeException e) {
        this.log.log(2, "The column 'Authors' in the scopus file cannot be normalized, because it cannot be interpreted as text. Skipping normalization of authors", (Throwable)e);
    }
}

