/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusetreeml.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import prefuse.data.Graph;
import prefuse.data.io.DataIOException;
import prefuse.data.io.TreeMLReader;

public class PrefuseTreeMLReader
implements Algorithm {
    private File inTreeMLFile;

    public PrefuseTreeMLReader(Data[] data, Dictionary parameters, CIShellContext context) {
        this.inTreeMLFile = (File)data[0].getData();
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            Graph graph = new TreeMLReader().readGraph((InputStream)new FileInputStream(this.inTreeMLFile));
            return this.createOutData(graph);
        }
        catch (DataIOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private Data[] createOutData(Graph graph) {
        Data[] dm = new Data[]{new BasicData((Object)graph, graph.getClass().getName())};
        dm[0].getMetadata().put("Label", "Prefuse Tree: " + this.inTreeMLFile);
        dm[0].getMetadata().put("Type", "Network");
        return dm;
    }
}

