/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusetreeml.reader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.UnicodeReader;
import prefuse.data.io.DataIOException;
import prefuse.data.io.TreeMLReader;

public class PrefuseTreeMLValidation
implements AlgorithmFactory {
    public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        return new PrefuseTreeMLValidationAlg(data, parameters, context);
    }

    public class PrefuseTreeMLValidationAlg
    implements Algorithm {
        public static final String TREEML_MIME_TYPE = "file:text/treeml+xml";
        private String inTreeMLFile;

        public PrefuseTreeMLValidationAlg(Data[] data, Dictionary parameters, CIShellContext context) {
            this.inTreeMLFile = (String)data[0].getData();
        }

        public Data[] execute() throws AlgorithmExecutionException {
            File inData = new File(this.inTreeMLFile);
            try {
                if (this.validateTreeMLHeader(inData)) {
                    new TreeMLReader().readGraph((InputStream)new FileInputStream(this.inTreeMLFile));
                    return this.createOutData(inData);
                }
                throw new AlgorithmExecutionException("TreeML file does not contain a valid header.");
            }
            catch (DataIOException e) {
                throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
            }
            catch (SecurityException e) {
                throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
            }
        }

        private Data[] createOutData(File inData) {
            Data[] dm = new Data[]{new BasicData((Object)inData, TREEML_MIME_TYPE)};
            dm[0].getMetadata().put("Label", "Prefuse TreeML file: " + this.inTreeMLFile);
            dm[0].getMetadata().put("Type", "Tree");
            return dm;
        }

        private boolean validateTreeMLHeader(File inData) throws FileNotFoundException, IOException {
            boolean hasTreeMLHeader = false;
            BufferedReader reader = new BufferedReader((Reader)new UnicodeReader((InputStream)new FileInputStream(inData)));
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("<tree")) {
                    hasTreeMLHeader = true;
                    break;
                }
                line = reader.readLine();
            }
            return hasTreeMLHeader;
        }
    }
}

