/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusetreeml.writer;

import edu.iu.nwb.converter.prefusetreeml.writer.prefusecode.TreeMLWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.FileUtilities;
import prefuse.data.Graph;
import prefuse.data.io.DataIOException;

public class PrefuseTreeMLWriter
implements Algorithm {
    public static final String TREEML_MIME_TYPE = "file:text/treeml+xml";
    private Graph inGraph;

    public PrefuseTreeMLWriter(Data[] data, Dictionary parameters, CIShellContext context) {
        this.inGraph = (Graph)data[0].getData();
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            File outTreeMLFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)"TreeML-", (String)"treeml.xml");
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(outTreeMLFile));
            new TreeMLWriter().writeGraph(this.inGraph, outStream);
            return new Data[]{new BasicData((Object)outTreeMLFile, TREEML_MIME_TYPE)};
        }
        catch (DataIOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }
}

