/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusexgmml.reader;

import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.io.XMLGraphReader;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;

public class PrefuseXGMMLReader
implements Algorithm {
    public static final String ID_KEY = "id";
    private File inGraphFile;

    public PrefuseXGMMLReader(Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
        this.inGraphFile = (File)data[0].getData();
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            Graph graph = new XMLGraphReader().loadGraph(this.inGraphFile.getAbsoluteFile());
            return this.createOutData(graph);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private Data[] createOutData(Graph graph) {
        BasicData outputData = new BasicData((Object)graph, Graph.class.getName());
        outputData.getMetadata().put("Label", "Old Prefuse Graph: " + this.inGraphFile);
        outputData.getMetadata().put("Type", "Network");
        return new Data[]{outputData};
    }
}

