/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusexgmml.reader;

import edu.berkeley.guir.prefuse.graph.io.XMLGraphReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.UnicodeReader;

public class PrefuseXGMMLValidation
implements AlgorithmFactory {
    public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        return new PrefuseXGMMLValidationAlg(data, parameters, context);
    }

    public class PrefuseXGMMLValidationAlg
    implements Algorithm {
        public static final String XGMML_MIME_TYPE = "file:text/xgmml+xml";
        private String inXGMMLFileName;

        public PrefuseXGMMLValidationAlg(Data[] data, Dictionary parameters, CIShellContext context) {
            this.inXGMMLFileName = (String)data[0].getData();
        }

        public Data[] execute() throws AlgorithmExecutionException {
            File inData = new File(this.inXGMMLFileName);
            try {
                if (this.validateXGMMLHeader(inData)) {
                    new XMLGraphReader().loadGraph(this.inXGMMLFileName);
                    return this.createOutData(inData);
                }
                throw new AlgorithmExecutionException("Couldn't validate " + this.inXGMMLFileName + " as an XGMML file.");
            }
            catch (FileNotFoundException e) {
                throw new AlgorithmExecutionException("Could not find XGMML file to validate: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
            }
        }

        private Data[] createOutData(File inData) {
            Data[] dm = new Data[]{new BasicData((Object)inData, XGMML_MIME_TYPE)};
            dm[0].getMetadata().put("Label", "Prefuse XGMML .xml file: " + this.inXGMMLFileName);
            dm[0].getMetadata().put("Type", "Network");
            return dm;
        }

        private boolean validateXGMMLHeader(File inData) throws FileNotFoundException, IOException {
            boolean hasXGMMLHeader = false;
            BufferedReader reader = new BufferedReader((Reader)new UnicodeReader((InputStream)new FileInputStream(inData)));
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("<graphml")) {
                    hasXGMMLHeader = false;
                    break;
                }
                if (line.startsWith("<graph ") || line.startsWith("<graph>")) {
                    hasXGMMLHeader = true;
                    break;
                }
                line = reader.readLine();
            }
            return hasXGMMLHeader;
        }
    }
}

