/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusexgmml.writer;

import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Graph;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PrefuseEdgeLabeler {
    public static final String EDGE_LABEL_JOINING_STRING = " to ";
    public static final String DEFAULT_EDGE_LABEL = "edge";

    public static void assignMissingEdgeLabels(Graph graph) {
        Set usedEdgeLabels = PrefuseEdgeLabeler.findUsedEdgeLabels(graph);
        Iterator edgeIterator = graph.getEdges();
        while (edgeIterator.hasNext()) {
            Edge edge = (Edge)edgeIterator.next();
            if (edge.getAttribute("label") != null) continue;
            String label = PrefuseEdgeLabeler.createSensibleEdgeLabel(edge, usedEdgeLabels);
            edge.setAttribute("label", label);
            usedEdgeLabels.add(label);
        }
    }

    private static Set findUsedEdgeLabels(Graph graph) {
        HashSet<String> usedEdgeLabels = new HashSet<String>(graph.getEdgeCount() / 2);
        Iterator edgeIterator = graph.getEdges();
        while (edgeIterator.hasNext()) {
            Edge edge = (Edge)edgeIterator.next();
            String edgeLabel = edge.getAttribute("label");
            if (edgeLabel == null) continue;
            usedEdgeLabels.add(edgeLabel);
        }
        return usedEdgeLabels;
    }

    private static String createSensibleEdgeLabel(Edge edge, Set usedEdgeLabels) {
        String uniqueNewEdgeLabel;
        String name = edge.getAttribute("name");
        if (name != null) {
            return name;
        }
        String id = edge.getAttribute("id");
        if (id != null) {
            return id;
        }
        String joinedNames = PrefuseEdgeLabeler.createEdgeLabelFromAttributeOfJoinedNodes(edge, "name");
        if (joinedNames != null) {
            return joinedNames;
        }
        String joinedLabels = PrefuseEdgeLabeler.createEdgeLabelFromAttributeOfJoinedNodes(edge, "label");
        if (joinedLabels != null) {
            return joinedLabels;
        }
        String joinedIDs = PrefuseEdgeLabeler.createEdgeLabelFromAttributeOfJoinedNodes(edge, "id");
        if (joinedIDs != null) {
            return joinedIDs;
        }
        int nextUnusedEdgeLabel = 0;
        while (usedEdgeLabels.contains(uniqueNewEdgeLabel = String.valueOf(++nextUnusedEdgeLabel))) {
        }
        return uniqueNewEdgeLabel;
    }

    private static String createEdgeLabelFromAttributeOfJoinedNodes(Edge edge, String attributeKey) {
        String firstNodeValue = edge.getFirstNode().getAttribute(attributeKey);
        String secondNodeValue = edge.getSecondNode().getAttribute(attributeKey);
        if (firstNodeValue != null && secondNodeValue != null) {
            return String.valueOf(firstNodeValue) + EDGE_LABEL_JOINING_STRING + secondNodeValue;
        }
        return null;
    }
}

