/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusexgmml.writer;

import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Node;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PrefuseNodeIDer {
    public static Graph assignMissingIDs(Graph graph) {
        PrefuseNodeIDer.assignNodeIDs(graph);
        PrefuseNodeIDer.updateAllEdgeSourcesAndTargets(graph);
        return graph;
    }

    private static void assignNodeIDs(Graph graph) {
        Set usedNodeIDs = PrefuseNodeIDer.findUsedNodeIDs(graph);
        int nextUnusedID = 0;
        Iterator nodeIterator = graph.getNodes();
        while (nodeIterator.hasNext()) {
            String uniqueNewNodeID;
            Node node = (Node)nodeIterator.next();
            if (node.getAttribute("id") != null) continue;
            while (usedNodeIDs.contains(uniqueNewNodeID = String.valueOf(++nextUnusedID))) {
            }
            node.setAttribute("id", uniqueNewNodeID);
        }
    }

    private static Set findUsedNodeIDs(Graph graph) {
        HashSet<String> usedNodeIDs = new HashSet<String>(graph.getNodeCount() / 2);
        Iterator nodeIterator = graph.getNodes();
        while (nodeIterator.hasNext()) {
            Node node = (Node)nodeIterator.next();
            String nodeID = node.getAttribute("id");
            if (nodeID == null) continue;
            usedNodeIDs.add(nodeID);
        }
        return usedNodeIDs;
    }

    private static void updateAllEdgeSourcesAndTargets(Graph graph) {
        Iterator edgeIterator = graph.getEdges();
        while (edgeIterator.hasNext()) {
            Edge edge = (Edge)edgeIterator.next();
            String source = edge.getFirstNode().getAttribute("id");
            edge.setAttribute("source", source);
            String target = edge.getSecondNode().getAttribute("id");
            edge.setAttribute("target", target);
        }
    }
}

