/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusexgmml.writer;

import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Node;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PrefuseNodeLabeler {
    public static void assignMissingNodeLabels(Graph graph) {
        Set usedNodeLabels = PrefuseNodeLabeler.findUsedNodeLabels(graph);
        Iterator nodeIterator = graph.getNodes();
        while (nodeIterator.hasNext()) {
            Node node = (Node)nodeIterator.next();
            if (node.getAttribute("label") != null) continue;
            String label = PrefuseNodeLabeler.createSensibleNodeLabel(node, usedNodeLabels);
            node.setAttribute("label", label);
            usedNodeLabels.add(label);
        }
    }

    private static Set findUsedNodeLabels(Graph graph) {
        HashSet<String> usedNodeLabels = new HashSet<String>(graph.getNodeCount() / 2);
        Iterator nodeIterator = graph.getNodes();
        while (nodeIterator.hasNext()) {
            Node node = (Node)nodeIterator.next();
            String nodeLabel = node.getAttribute("label");
            if (nodeLabel == null) continue;
            usedNodeLabels.add(nodeLabel);
        }
        return usedNodeLabels;
    }

    private static String createSensibleNodeLabel(Node node, Set usedNodeLabels) {
        String uniqueNewNodeLabel;
        String name = node.getAttribute("name");
        if (name != null) {
            return name;
        }
        String id = node.getAttribute("id");
        if (id != null) {
            return id;
        }
        int nextUnusedNodeLabel = 0;
        while (usedNodeLabels.contains(uniqueNewNodeLabel = String.valueOf(++nextUnusedNodeLabel))) {
        }
        return uniqueNewNodeLabel;
    }
}

