/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusexgmml.writer;

import edu.berkeley.guir.prefuse.graph.Graph;
import edu.iu.nwb.converter.prefusexgmml.writer.XGMMLGraphWriter;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.FileUtilities;

public class PrefuseXGMMLWriter
implements Algorithm {
    public static final String XGMML_MIME_TYPE = "file:text/xgmml+xml";
    public static final String XGMML_FILE_EXTENSION = "xgmml.xml";
    private Graph inGraph;

    public PrefuseXGMMLWriter(Data[] data, Dictionary parameters, CIShellContext context) {
        this.inGraph = (Graph)data[0].getData();
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            File outXGMMLFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)"XGMML-", (String)XGMML_FILE_EXTENSION);
            new XGMMLGraphWriter().writeGraph(this.inGraph, outXGMMLFile);
            return new Data[]{new BasicData((Object)outXGMMLFile, XGMML_MIME_TYPE)};
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }
}

