/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusexgmml.writer;

import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Entity;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.io.AbstractGraphWriter;
import edu.iu.nwb.converter.prefusexgmml.writer.PrefuseEdgeLabeler;
import edu.iu.nwb.converter.prefusexgmml.writer.PrefuseNodeIDer;
import edu.iu.nwb.converter.prefusexgmml.writer.PrefuseNodeLabeler;
import edu.iu.nwb.converter.prefusexgmml.writer.XMLLib;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class XGMMLGraphWriter
extends AbstractGraphWriter {
    public static final String NODE = "node";
    public static final String EDGE = "edge";
    public static final String ATT = "att";
    public static final String ID = "id";
    public static final String LABEL = "label";
    public static final String SOURCE = "source";
    public static final String TARGET = "target";
    public static final String WEIGHT = "weight";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String LIST = "list";
    public static final String GRAPH = "graph";
    public static final String DIRECTED = "directed";
    public static final String[] NODE_XML_ATTRIBUTES = new String[]{"id", "name", "label", "weight"};
    public static final String[] EDGE_XML_ATTRIBUTES = new String[]{"id", "name", "label", "weight", "source", "target"};
    public static final String DEFAULT_GRAPH_LABEL = "Network";
    public static final String NODE_INDENT = "  ";
    public static final String EDGE_INDENT = "  ";
    public static final String ATT_INDENT = "    ";
    public static final String NODES_LISTING_COMMENT = "<!-- nodes -->";
    public static final String EDGES_LISTING_COMMENT = "<!-- edges -->";
    public static final String XML_NAMESPACE_ATTRIBUTE_KEY = "xmlns";
    public static final String XGMML_NAMESPACE = "http://www.cs.rpi.edu/XGMML";

    public void writeGraph(Graph graph, OutputStream os) {
        PrefuseNodeIDer.assignMissingIDs(graph);
        PrefuseNodeLabeler.assignMissingNodeLabels(graph);
        PrefuseEdgeLabeler.assignMissingEdgeLabels(graph);
        this.writeGraphToFile(graph, os);
    }

    private void writeGraphToFile(Graph graph, OutputStream os) {
        PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(os));
        printWriter.print(this.createGraphXML(graph));
        printWriter.flush();
    }

    private String createGraphXML(Graph graph) {
        String xml = "";
        xml = String.valueOf(xml) + this.createGraphStartElement(graph) + "\n";
        xml = String.valueOf(xml) + this.createNodesXML(graph);
        xml = String.valueOf(xml) + this.createEdgesXML(graph);
        xml = String.valueOf(xml) + this.createElementEndTag(GRAPH) + "\n";
        return xml;
    }

    private String createGraphStartElement(Graph graph) {
        String directed = graph.isDirected() ? "1" : "0";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(LABEL, DEFAULT_GRAPH_LABEL);
        attributes.put(DIRECTED, directed);
        attributes.put(XML_NAMESPACE_ATTRIBUTE_KEY, XGMML_NAMESPACE);
        return this.createElementStartTag(GRAPH, attributes);
    }

    private String createNodesXML(Graph graph) {
        String xml = "";
        xml = String.valueOf(xml) + "  <!-- nodes -->\n";
        Iterator nodes = graph.getNodes();
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            xml = String.valueOf(xml) + this.createNodeXML(node);
        }
        return xml;
    }

    private String createNodeXML(Node node) {
        String xml = "";
        xml = String.valueOf(xml) + "  " + this.createNodeStartTag(node) + "\n";
        xml = String.valueOf(xml) + this.createAttsXML((Entity)node, NODE_XML_ATTRIBUTES);
        xml = String.valueOf(xml) + "  " + this.createElementEndTag(NODE) + "\n";
        return xml;
    }

    private String createNodeStartTag(Node node) {
        Map xmlAttributesMap = this.getXMLAttributesMap((Entity)node, NODE_XML_ATTRIBUTES);
        return this.createElementStartTag(NODE, xmlAttributesMap);
    }

    private String createEdgesXML(Graph graph) {
        String xml = "";
        xml = String.valueOf(xml) + "  <!-- edges -->\n";
        Iterator edges = graph.getEdges();
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            xml = String.valueOf(xml) + this.createEdgeXML(edge);
        }
        return xml;
    }

    private String createEdgeXML(Edge edge) {
        String xml = "";
        xml = String.valueOf(xml) + "  " + this.createEdgeStartTag(edge) + "\n";
        xml = String.valueOf(xml) + this.createAttsXML((Entity)edge, EDGE_XML_ATTRIBUTES);
        xml = String.valueOf(xml) + "  " + this.createElementEndTag(EDGE) + "\n";
        return xml;
    }

    private String createEdgeStartTag(Edge edge) {
        Map xmlAttributesMap = this.getXMLAttributesMap((Entity)edge, EDGE_XML_ATTRIBUTES);
        return this.createElementStartTag(EDGE, xmlAttributesMap);
    }

    private Map getXMLAttributesMap(Entity e, String[] xmlAttributeKeys) {
        HashMap<String, String> xmlAttributes = new HashMap<String, String>();
        int i = 0;
        while (i < xmlAttributeKeys.length) {
            String key = xmlAttributeKeys[i];
            String value = e.getAttribute(key);
            if (value != null) {
                xmlAttributes.put(key, value);
            }
            ++i;
        }
        return xmlAttributes;
    }

    private String createAttsXML(Entity entity, String[] xmlAttributeKeys) {
        String xml = "";
        Map attMap = entity.getAttributes();
        for (Map.Entry att : attMap.entrySet()) {
            boolean xmlAttribute = this.contains(xmlAttributeKeys, (String)att.getKey());
            if (xmlAttribute) continue;
            xml = String.valueOf(xml) + ATT_INDENT + this.createAttStartTag(att);
            xml = String.valueOf(xml) + this.createElementEndTag(ATT) + "\n";
        }
        return xml;
    }

    private String createAttStartTag(Map.Entry attBinding) {
        String key = (String)attBinding.getKey();
        String value = (String)attBinding.getValue();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(NAME, key);
        attributes.put(VALUE, value);
        return this.createElementStartTag(ATT, attributes);
    }

    private String createElementStartTag(String elementName, Map xmlAttributesMap) {
        String tag = "";
        tag = String.valueOf(tag) + "<";
        tag = String.valueOf(tag) + elementName;
        for (Map.Entry xmlAttributeBinding : xmlAttributesMap.entrySet()) {
            tag = String.valueOf(tag) + " " + this.createAttributeString(xmlAttributeBinding);
        }
        tag = String.valueOf(tag) + ">";
        return tag;
    }

    private String createElementEndTag(String elementName) {
        return "</" + elementName + ">";
    }

    private String createAttributeString(Map.Entry attributePair) {
        String key = (String)attributePair.getKey();
        String value = (String)attributePair.getValue();
        return String.valueOf(key) + "=\"" + XMLLib.EscapeString(value) + "\"";
    }

    private boolean contains(String[] list, String item) {
        int i = 0;
        while (i < list.length) {
            if (list[i].equals(item)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

