/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusexgmml.writer;

public class XMLLib {
    private static final char LOWER_RANGE = ' ';
    private static final char UPPER_RANGE = '\u007f';
    private static final char[] VALID_CHARS = new char[]{'\t', '\n', '\r'};
    private static final char[] INVALID = new char[]{'<', '>', '\"', '\'', '&'};
    private static final String[] VALID = new String[]{"&lt;", "&gt;", "&quot;", "&apos;", "&amp;"};

    public static String EscapeString(String str) {
        StringBuffer sbuf = new StringBuffer();
        XMLLib.EscapeString(str, sbuf);
        return sbuf.toString();
    }

    public static void EscapeString(String str, StringBuffer sbuf) {
        if (sbuf == null) {
            throw new IllegalArgumentException("Input StringBuffer must be non-null.");
        }
        if (str == null) {
            sbuf.append("null");
            return;
        }
        int len = str.length();
        sbuf.ensureCapacity(sbuf.length() + 2 * len);
        char[] buf = str.toCharArray();
        int i = 0;
        while (i < len) {
            char c = buf[i];
            if (c < ' ' && c != VALID_CHARS[0] && c != VALID_CHARS[1] && c != VALID_CHARS[2] || c > '\u007f') {
                sbuf.append("&#");
                sbuf.append(Integer.toString(c));
                sbuf.append(';');
            } else {
                boolean valid = true;
                int j = INVALID.length - 1;
                while (j >= 0) {
                    if (INVALID[j] == c) {
                        valid = false;
                        sbuf.append(VALID[j]);
                        break;
                    }
                    --j;
                }
                if (valid) {
                    sbuf.append(c);
                }
            }
            ++i;
        }
    }
}

