/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.tablegraph;

import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.expression.Expression;

public class GraphTable
implements Algorithm {
    private Data[] data;

    public GraphTable(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
    }

    public Data[] execute() {
        Graph graph = (Graph)this.data[0].getData();
        Table nodeTable = graph.getNodeTable();
        if (graph.getNodeKeyField() == null) {
            nodeTable.addColumn("id", (Expression)new AbstractExpression(){

                public Class getType(Schema arg0) {
                    return Integer.TYPE;
                }

                public int getInt(Tuple t) {
                    return t.getRow();
                }

                public Object get(Tuple t) {
                    return new Integer(this.getInt(t));
                }
            });
        }
        BasicData nodeData = new BasicData((Object)nodeTable, Table.class.getName());
        Dictionary nodeMetadata = nodeData.getMetadata();
        nodeMetadata.put("Label", "Node Table from Graph");
        nodeMetadata.put("Parent", this.data[0]);
        nodeMetadata.put("Type", "Table");
        BasicData edgeData = new BasicData((Object)graph.getEdgeTable(), Table.class.getName());
        Dictionary edgeMetadata = edgeData.getMetadata();
        edgeMetadata.put("Label", "Edge Table from Graph");
        edgeMetadata.put("Parent", this.data[0]);
        edgeMetadata.put("Type", "Table");
        return new Data[]{nodeData, edgeData};
    }
}

