/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.cocitationsimilarity;

import edu.iu.nwb.preprocessing.cocitationsimilarity.CocitationComputation;
import edu.iu.nwb.preprocessing.cocitationsimilarity.Merger;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.templates.staticexecutable.StaticExecutableAlgorithmFactory;
import org.osgi.framework.BundleContext;

public class CoCitationSimilarityAlgorithm
implements Algorithm {
    private static StaticExecutableAlgorithmFactory staticAlgorithmFactory;
    Data[] data;
    Dictionary parameters;
    CIShellContext context;

    public CoCitationSimilarityAlgorithm(Data[] data, Dictionary parameters, CIShellContext context, BundleContext bContext) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
        if (staticAlgorithmFactory == null) {
            staticAlgorithmFactory = new StaticExecutableAlgorithmFactory("cocitation", bContext);
        }
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            File inputNWBFile = (File)this.data[0].getData();
            File outputNWBFile = File.createTempFile("CoCitationSimilarity-", ".nwb");
            NWBFileParser parser = new NWBFileParser(inputNWBFile);
            CocitationComputation computation = new CocitationComputation();
            parser.parse((NWBFileParserHandler)computation);
            parser = new NWBFileParser(inputNWBFile);
            parser.parse((NWBFileParserHandler)new Merger(computation, outputNWBFile));
            BasicData outNWBData = new BasicData((Object)outputNWBFile, "file:text/nwb");
            outNWBData.getMetadata().put("Label", "Bibliographic Coupling Similarity Network");
            outNWBData.getMetadata().put("Type", "Network");
            outNWBData.getMetadata().put("Parent", this.data[0]);
            return new Data[]{outNWBData};
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (ParsingException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }
}

