/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.cocitationsimilarity;

import edu.iu.nwb.preprocessing.cocitationsimilarity.CocitationComputation;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Merger
implements NWBFileParserHandler {
    private NWBFileWriter out;
    private NWBFileParser parser;
    private File edgeFile;
    private boolean startedEdges;
    private Map citationCount;
    private Map cocitationCount;

    public Merger(File edgeFile, File srcNWBFile, File outputNWBFile) throws IOException {
        this.edgeFile = edgeFile;
        this.startedEdges = false;
        this.out = new NWBFileWriter(outputNWBFile);
        this.parser = new NWBFileParser(srcNWBFile);
    }

    public Merger(CocitationComputation computation, File outputNWBFile) throws IOException {
        this.startedEdges = false;
        this.out = new NWBFileWriter(outputNWBFile);
        this.citationCount = computation.citationCount;
        this.cocitationCount = computation.cocitationCount;
    }

    public void setNodeCount(int numberOfNodes) {
        this.out.setNodeCount(numberOfNodes);
    }

    public void setNodeSchema(LinkedHashMap schema) {
        schema.put("references", "int");
        this.out.setNodeSchema(schema);
    }

    public void addNode(int id, String label, Map attributes) {
        Integer citations = (Integer)this.citationCount.get(new Integer(id));
        if (citations == null) {
            citations = new Integer(0);
        }
        attributes.put("references", citations);
        this.out.addNode(id, label, attributes);
    }

    public void addDirectedEdge(int sourceNode, int targetNode, Map attributes) {
    }

    public void addUndirectedEdge(int node1, int node2, Map attributes) {
    }

    public void setDirectedEdgeCount(int numberOfEdges) {
    }

    public void setDirectedEdgeSchema(LinkedHashMap schema) {
        this.startedEdges = true;
    }

    public void setUndirectedEdgeCount(int numberOfEdges) {
    }

    public void setUndirectedEdgeSchema(LinkedHashMap schema) {
        this.startedEdges = true;
    }

    public void addComment(String comment) {
        if (!this.startedEdges) {
            this.out.addComment(comment);
        }
    }

    public void finishedParsing() {
        LinkedHashMap<String, String> schema = new LinkedHashMap<String, String>();
        schema.put("source", "int");
        schema.put("target", "int");
        schema.put("weight", "int");
        this.out.setUndirectedEdgeSchema(schema);
        for (Set pair : this.cocitationCount.keySet()) {
            int pairCount = (Integer)this.cocitationCount.get(pair);
            Integer[] both = pair.toArray(new Integer[0]);
            HashMap<String, Integer> attributes = new HashMap<String, Integer>();
            attributes.put("weight", new Integer(pairCount));
            this.out.addUndirectedEdge(both[0].intValue(), both[1].intValue(), attributes);
        }
        this.out.finishedParsing();
    }

    public boolean haltParsingNow() {
        return this.startedEdges;
    }
}

