/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.cocitationsimilarity;

import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileWriter;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class NWBEdgeMerger
implements NWBFileParserHandler {
    private NWBFileWriter out;
    private NWBFileParser parser;
    private File edgeFile;
    private boolean startedEdges;

    public NWBEdgeMerger(File edgeFile, File srcNWBFile, File outputNWBFile) throws IOException {
        this.edgeFile = edgeFile;
        this.startedEdges = false;
        this.out = new NWBFileWriter(outputNWBFile);
        this.parser = new NWBFileParser(srcNWBFile);
    }

    public void merge() throws IOException, ParsingException {
        this.parser.parse((NWBFileParserHandler)this);
    }

    public void setNodeCount(int numberOfNodes) {
        this.out.setNodeCount(numberOfNodes);
    }

    public void setNodeSchema(LinkedHashMap schema) {
        this.out.setNodeSchema(schema);
    }

    public void addNode(int id, String label, Map attributes) {
        this.out.addNode(id, label, attributes);
    }

    public void addDirectedEdge(int sourceNode, int targetNode, Map attributes) {
    }

    public void addUndirectedEdge(int node1, int node2, Map attributes) {
    }

    public void setDirectedEdgeCount(int numberOfEdges) {
    }

    public void setDirectedEdgeSchema(LinkedHashMap schema) {
        this.startedEdges = true;
    }

    public void setUndirectedEdgeCount(int numberOfEdges) {
    }

    public void setUndirectedEdgeSchema(LinkedHashMap schema) {
        this.startedEdges = true;
    }

    public void addComment(String comment) {
        if (!this.startedEdges) {
            this.out.addComment(comment);
        }
    }

    public void finishedParsing() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.edgeFile), "UTF-8"));
            LinkedHashMap<String, String> schema = new LinkedHashMap<String, String>();
            schema.put("source", "int");
            schema.put("target", "int");
            schema.put("weight", "real");
            this.out.setUndirectedEdgeSchema(schema);
            String line = in.readLine();
            while (line != null) {
                StringTokenizer st = new StringTokenizer(line.trim());
                if (st.countTokens() > 1) {
                    int sourceNode = Integer.parseInt(st.nextToken());
                    int targetNode = Integer.parseInt(st.nextToken());
                    Double similarity = new Double(st.nextToken());
                    HashMap<String, Double> attributes = new HashMap<String, Double>();
                    attributes.put("weight", similarity);
                    this.out.addUndirectedEdge(sourceNode, targetNode, attributes);
                }
                line = in.readLine();
            }
            this.out.finishedParsing();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean haltParsingNow() {
        return this.startedEdges;
    }
}

