/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.csv;

import edu.iu.nwb.preprocessing.csv.CSVTableReader;
import java.util.Dictionary;
import java.util.HashMap;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.io.DataIOException;

public class CsvAlgorithm
implements Algorithm {
    Data[] data;
    Dictionary parameters;
    CIShellContext context;

    public CsvAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        CSVTableReader tableReader = new CSVTableReader();
        tableReader.setHasHeader(true);
        Table nodes = null;
        Table edges = null;
        try {
            nodes = tableReader.readTable((String)this.parameters.get("nodes"));
            edges = tableReader.readTable((String)this.parameters.get("edges"));
        }
        catch (DataIOException e) {
            throw new AlgorithmExecutionException("Error reading tables: " + e.getMessage(), (Throwable)e);
        }
        String nodeId = (String)this.parameters.get("nodeid");
        String first = (String)this.parameters.get("first");
        String second = (String)this.parameters.get("second");
        String nwbId = "_x_nwb_id";
        nodes.addColumn(nwbId, Integer.TYPE);
        String nwbFirst = "_x_nwb_first";
        edges.addColumn(nwbFirst, Integer.TYPE);
        String nwbSecond = "_x_nwb_second";
        edges.addColumn(nwbSecond, Integer.TYPE);
        int nodeCount = nodes.getRowCount();
        HashMap<Object, Integer> newIds = new HashMap<Object, Integer>(nodeCount);
        int currentId = 0;
        int row = 0;
        while (row < nodeCount) {
            Tuple node = nodes.getTuple(row);
            newIds.put(node.get(nodeId), new Integer(currentId));
            node.setInt(nwbId, currentId);
            ++currentId;
            ++row;
        }
        int edgeCount = edges.getRowCount();
        int row2 = 0;
        while (row2 < edgeCount) {
            Tuple edge = edges.getTuple(row2);
            edge.setInt(nwbFirst, ((Integer)newIds.get(edge.get(first))).intValue());
            edge.setInt(nwbSecond, ((Integer)newIds.get(edge.get(second))).intValue());
            ++row2;
        }
        Graph graph = new Graph(nodes, edges, false, nwbId, nwbFirst, nwbSecond);
        BasicData data = new BasicData((Object)graph, Graph.class.getName());
        Dictionary metadata = data.getMetadata();
        metadata.put("Label", "Prefuse Beta Graph from CSV");
        metadata.put("Type", "Network");
        return new Data[]{data};
    }
}

