/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.deleteisolates;

import edu.iu.nwb.preprocessing.deleteisolates.exceptions.IsolateNodeStrippingException;
import edu.iu.nwb.preprocessing.deleteisolates.exceptions.NonIsolateNodeFindingException;
import edu.iu.nwb.preprocessing.deleteisolates.nwbfileparserhandlers.NodeIDFilteringNWBWriter;
import edu.iu.nwb.preprocessing.deleteisolates.nwbfileparserhandlers.NonIsolateFinder;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Set;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.FileUtilities;
import org.osgi.service.log.LogService;

public class DeleteIsolatesAlgorithm
implements Algorithm {
    public static final String OUTPUT_DATA_LABEL = "With isolates removed";
    private Data inData;
    private LogService logService;

    public DeleteIsolatesAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.inData = data[0];
        this.logService = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            File inputNWBFile = (File)this.inData.getData();
            Set nonIsolateNodeIDs = this.findNonIsolateNodes(inputNWBFile);
            File isolateFreeNWBFile = this.copyNWBFileWithoutIsolates(inputNWBFile, nonIsolateNodeIDs);
            return this.createOutputData(isolateFreeNWBFile);
        }
        catch (NonIsolateNodeFindingException nonIsolateNodeFindingException) {
            throw new AlgorithmExecutionException((Throwable)nonIsolateNodeFindingException);
        }
        catch (IsolateNodeStrippingException isolateNodeStrippingException) {
            throw new AlgorithmExecutionException((Throwable)isolateNodeStrippingException);
        }
    }

    private Set findNonIsolateNodes(File inputNWBFile) throws NonIsolateNodeFindingException {
        try {
            NonIsolateFinder nonIsolateFinder = new NonIsolateFinder();
            NWBFileParser nonIsolateFinderFileParser = new NWBFileParser(inputNWBFile);
            nonIsolateFinderFileParser.parse((NWBFileParserHandler)nonIsolateFinder);
            return nonIsolateFinder.getNonIsolateNodeIDs();
        }
        catch (IOException ioException) {
            throw new NonIsolateNodeFindingException(ioException);
        }
        catch (ParsingException parsingException) {
            throw new NonIsolateNodeFindingException(parsingException);
        }
    }

    private File copyNWBFileWithoutIsolates(File inputNWBFile, Set nonIsolateNodeIDs) throws IsolateNodeStrippingException {
        try {
            File outputNWBFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)"DeleteIsolates-", (String)"nwb");
            NodeIDFilteringNWBWriter nodeIDFilteringNWBWriter = new NodeIDFilteringNWBWriter(nonIsolateNodeIDs, outputNWBFile);
            NWBFileParser isolateStripperFileParser = new NWBFileParser(inputNWBFile);
            isolateStripperFileParser.parse((NWBFileParserHandler)nodeIDFilteringNWBWriter);
            this.logNumberOfDeletedIsolates(nodeIDFilteringNWBWriter.getNumberFiltered());
            return outputNWBFile;
        }
        catch (IOException ioException) {
            throw new IsolateNodeStrippingException(ioException);
        }
        catch (ParsingException parsingException) {
            throw new IsolateNodeStrippingException(parsingException);
        }
    }

    private void logNumberOfDeletedIsolates(int numberOfDeletedIsolates) {
        String pluralizedNodeString = numberOfDeletedIsolates == 1 ? " isolate node." : " isolate nodes.";
        this.logService.log(3, "Removed " + numberOfDeletedIsolates + pluralizedNodeString);
    }

    private Data[] createOutputData(File outputNWBFile) {
        BasicData outputFileData = new BasicData((Object)outputNWBFile, "file:text/nwb");
        Dictionary outputFileMetadata = outputFileData.getMetadata();
        outputFileMetadata.put("Label", OUTPUT_DATA_LABEL);
        outputFileMetadata.put("Parent", this.inData);
        outputFileMetadata.put("Type", "Network");
        return new Data[]{outputFileData};
    }

    public static class Factory
    implements AlgorithmFactory {
        public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
            return new DeleteIsolatesAlgorithm(data, parameters, context);
        }
    }
}

