/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.duplicatenodedetector.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Stack;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;

public class GraphSearchAlgorithms {
    public static LinkedHashSet undirectedDepthFirstSearch(Graph g, Integer n) {
        LinkedHashSet nodeSet = new LinkedHashSet();
        if (n == null) {
            Iterator it = g.nodes();
            while (it.hasNext()) {
                Integer nodeNumber = new Integer(((Node)it.next()).getRow());
                GraphSearchAlgorithms.runUDFS(g, nodeNumber, nodeSet);
            }
        } else {
            Integer nodeNumber = new Integer(n);
            GraphSearchAlgorithms.runUDFS(g, nodeNumber, nodeSet);
        }
        return nodeSet;
    }

    public static LinkedHashSet directedDepthFirstSearch(Graph g, Integer n, boolean getPreOrder, boolean isReverse) {
        LinkedHashSet nodeSet = new LinkedHashSet();
        Graph g2 = g;
        if (isReverse && isReverse) {
            g2 = GraphSearchAlgorithms.reverseGraph(g);
        }
        if (n == null) {
            Iterator it = g2.nodes();
            while (it.hasNext()) {
                Integer nodeNumber = new Integer(((Node)it.next()).getRow());
                GraphSearchAlgorithms.runDDFS(g2, nodeNumber, nodeSet, getPreOrder);
            }
        } else {
            GraphSearchAlgorithms.runDDFS(g2, n, nodeSet, getPreOrder);
        }
        return nodeSet;
    }

    private static void runUDFS(Graph graph, Integer startingNodeIndex, LinkedHashSet alreadyCheckedNodes) {
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.add(startingNodeIndex);
        while (!queue.isEmpty()) {
            Integer nodeRow = (Integer)queue.removeFirst();
            if (alreadyCheckedNodes.contains(nodeRow)) continue;
            Node node = graph.getNode(nodeRow.intValue());
            alreadyCheckedNodes.add(nodeRow);
            Iterator edgeIt = node.edges();
            while (edgeIt.hasNext()) {
                Node source;
                Integer sourceRow;
                Edge edge = (Edge)edgeIt.next();
                Node targetNode = edge.getTargetNode();
                Integer targetRow = new Integer(targetNode.getRow());
                if (!alreadyCheckedNodes.contains(targetRow)) {
                    queue.add(targetRow);
                }
                if (alreadyCheckedNodes.contains(sourceRow = new Integer((source = edge.getSourceNode()).getRow()))) continue;
                queue.add(sourceRow);
            }
        }
    }

    public static Graph reverseGraph(Graph g) {
        Graph g2 = g;
        Iterator it = g.edges();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            int edgeRow = e.getRow();
            e = g2.getEdge(edgeRow);
            int newTarget = e.getSourceNode().getRow();
            int newSource = e.getTargetNode().getRow();
            e.set(0, (Object)new Integer(newSource));
            e.set(1, (Object)new Integer(newTarget));
        }
        return g2;
    }

    private static void runDDFS(Graph g, Integer n, LinkedHashSet nodeSet, boolean isPreOrder) {
        Integer nodeNumber;
        Node nd2;
        Node nd;
        Integer nodeRow;
        boolean done = false;
        Stack<Integer> nodeStack = new Stack<Integer>();
        nodeStack.add(new Integer(n));
        while (!nodeStack.isEmpty()) {
            nodeRow = (Integer)nodeStack.peek();
            nd = g.getNode(nodeRow.intValue());
            if (!nodeSet.contains(nodeRow)) {
                if (isPreOrder) {
                    nodeSet.add(nodeRow);
                }
                nodeSet.add(nodeRow);
            }
            done = true;
            Iterator it = nd.outNeighbors();
            while (it.hasNext()) {
                nd2 = (Node)it.next();
                nodeNumber = new Integer(nd2.getRow());
                if (nodeSet.contains(nodeNumber)) continue;
                nodeStack.add(nodeNumber);
                done = false;
                break;
            }
            if (!done) continue;
            if (!isPreOrder) {
                nodeSet.add(nodeRow);
            }
            nodeStack.pop();
        }
        nodeStack = null;
        nd = null;
        nd2 = null;
        nodeRow = null;
        nodeNumber = null;
    }
}

