/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.extractnodesandedges.extractnodes.abovebelow;

import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileUtilities;
import edu.iu.nwb.util.nwbfile.NWBFileWriter;
import edu.iu.nwb.util.nwbfile.ParsingException;
import edu.iu.nwb.util.nwbfile.model.AttributePredicate;
import edu.iu.nwb.util.nwbfile.model.AttributePredicates;
import edu.iu.nwb.util.nwbfile.pipe.ParserPipe;
import edu.iu.nwb.util.nwbfile.pipe.ParserStage;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;

public class ExtractNodesAboveBelowAlgorithm
implements Algorithm {
    Data[] data;
    private double limit;
    private boolean fromBottomInstead;
    private String numericAttribute;
    private boolean noParams = false;

    public ExtractNodesAboveBelowAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
        this.data = data;
        if (parameters.get("numericAttribute") == null) {
            LogService logger = (LogService)context.getService(LogService.class.toString());
            logger.log(2, String.valueOf(this.getClass().toString()) + " called with empty parameter list");
            this.noParams = true;
            return;
        }
        this.limit = ((Number)parameters.get("fromThisNum")).doubleValue();
        this.fromBottomInstead = (Boolean)parameters.get("belowInstead");
        this.numericAttribute = (String)parameters.get("numericAttribute");
    }

    public Data[] execute() throws AlgorithmExecutionException {
        if (this.noParams) {
            return null;
        }
        try {
            File inFile = (File)this.data[0].getData();
            File outFile = NWBFileUtilities.createTemporaryNWBFile();
            NWBFileParser reader = new NWBFileParser(inFile);
            AttributePredicate filter = this.fromBottomInstead ? AttributePredicates.keepBelow((String)this.numericAttribute, (double)this.limit) : AttributePredicates.keepAbove((String)this.numericAttribute, (double)this.limit);
            ParserStage handler = ParserPipe.create().requireNodeAttribute(this.numericAttribute).filterNodes(filter).outputTo((NWBFileParserHandler)new NWBFileWriter(outFile));
            reader.parse((NWBFileParserHandler)handler);
            return this.createOutputData(outFile);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException((Throwable)e);
        }
        catch (ParsingException e) {
            throw new AlgorithmExecutionException((Throwable)e);
        }
    }

    private Data[] createOutputData(File outputNWBFile) {
        String label = String.format("Nodes %s %f by %s", this.fromBottomInstead ? "below" : "above", this.limit, this.numericAttribute);
        BasicData outputFileData = new BasicData((Object)outputNWBFile, "file:text/nwb");
        Dictionary outputFileMetadata = outputFileData.getMetadata();
        outputFileMetadata.put("Label", label);
        outputFileMetadata.put("Parent", this.data[0]);
        outputFileMetadata.put("Type", "Network");
        return new Data[]{outputFileData};
    }
}

