/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.pathfindernetworkscaling.fast;

import edu.iu.nwb.converter.nwb.common.ValidateNWBFile;
import edu.iu.nwb.preprocessing.pathfindernetworkscaling.fast.FastPathfinderNetworkScalingComputation;
import edu.iu.nwb.preprocessing.pathfindernetworkscaling.fast.FastPathfinderNetworkScalingOutputGenerator;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;

public class FastPathfinderNetworkScalingAlgorithm
implements Algorithm {
    private Data[] data;
    private Dictionary parameters;
    private LogService logger;
    private int numberOfEdges;
    private int numberOfNodes;
    private boolean isUndirectedNetwork;
    private boolean isUnweightedNetwork;
    private double rParameter;
    public static final String WEIGHT_DISSIMILARITY = "DISSIMILARITY";
    public static final String WEIGHT_SIMILARITY = "SIMILARITY";

    public FastPathfinderNetworkScalingAlgorithm(Data[] data, Dictionary parameters, CIShellContext context, boolean isUnweighted) {
        this.data = data;
        this.parameters = parameters;
        this.logger = (LogService)context.getService(LogService.class.getName());
        this.isUnweightedNetwork = isUnweighted;
    }

    private void printFastPathfinderUsageWarnings(String type) {
        if (type.equalsIgnoreCase("UNDIRECTED")) {
            this.logger.log(2, "For undirected networks, use MST Pathfinder network scaling algorithm for faster results.\n");
        }
        if (type.equalsIgnoreCase("UNWEIGHTED")) {
            this.logger.log(2, "For undirected networks having edges with no weight, use MST Pathfinder network scaling algorithm for faster & better results.\n");
        }
        if (type.equalsIgnoreCase("SCALING_RATIO")) {
            this.logger.log(2, "The low scaling ratio (<= 1.5) is probably caused due to many of the edge weights being equal to the minimum edge weight. Better results can be obtained if MST Pathfinder algorithm is used. But it only works for Undirected networks.\n");
        }
    }

    public Data[] execute() throws AlgorithmExecutionException {
        File inputData = (File)this.data[0].getData();
        try {
            this.validateInputFile(inputData);
        }
        catch (ParsingException e) {
            throw new AlgorithmExecutionException("Inappropriate NWB File provided.", (Throwable)e);
        }
        if (this.isUndirectedNetwork) {
            this.printFastPathfinderUsageWarnings("UNDIRECTED");
        }
        if (this.isUnweightedNetwork) {
            this.printFastPathfinderUsageWarnings("UNWEIGHTED");
        }
        if (this.numberOfEdges > 1 && this.numberOfNodes > 1) {
            try {
                String edgeWeightColumnName = (String)this.parameters.get("weightcolumn");
                String edgeWeightType = (String)this.parameters.get("weighttypecolumn");
                this.rParameter = (Boolean)this.parameters.get("rinfinity") != false ? Double.POSITIVE_INFINITY : Double.parseDouble(this.parameters.get("rparameter").toString());
                NWBFileParser parser = new NWBFileParser(inputData);
                FastPathfinderNetworkScalingComputation networkScalingComputation = new FastPathfinderNetworkScalingComputation(edgeWeightColumnName, edgeWeightType, this.rParameter, this.numberOfNodes, this.logger);
                parser.parse((NWBFileParserHandler)networkScalingComputation);
                File outputNWBFile = File.createTempFile("nwb-", ".nwb");
                NWBFileParser outputParser = new NWBFileParser(inputData);
                FastPathfinderNetworkScalingOutputGenerator scalingOutputGenerator = new FastPathfinderNetworkScalingOutputGenerator(networkScalingComputation, outputNWBFile);
                outputParser.parse((NWBFileParserHandler)scalingOutputGenerator);
                BasicData outNWBData = new BasicData((Object)outputNWBFile, "file:text/nwb");
                this.prepareOutputMetadata(edgeWeightType, scalingOutputGenerator, (Data)outNWBData);
                return new Data[]{outNWBData};
            }
            catch (FileNotFoundException e) {
                throw new AlgorithmExecutionException("NWB File'" + inputData.getAbsolutePath() + "' not found.", (Throwable)e);
            }
            catch (IOException e) {
                throw new AlgorithmExecutionException((Throwable)e);
            }
            catch (ParsingException e) {
                throw new AlgorithmExecutionException((Throwable)e);
            }
        }
        throw new AlgorithmExecutionException("Input network should have more than 1 edge & 1 node.");
    }

    private void prepareOutputMetadata(String edgeWeightType, FastPathfinderNetworkScalingOutputGenerator scalingOutputGenerator, Data outNWBData) {
        double scalingRatio = this.calculateScalingRatio(this.numberOfEdges, scalingOutputGenerator.getScaledNetworkEdgeCount());
        outNWBData.getMetadata().put("Label", "Fast Pathfinder Network Scaling used weight " + edgeWeightType + " & value of r = " + this.rParameter + " to reduce " + this.numberOfEdges + " edges to " + scalingOutputGenerator.getScaledNetworkEdgeCount() + ". Scaling ratio = " + scalingRatio);
        outNWBData.getMetadata().put("Type", "Network");
        outNWBData.getMetadata().put("Parent", this.data[0]);
        if (scalingRatio <= 1.5) {
            this.printFastPathfinderUsageWarnings("SCALING_RATIO");
        }
    }

    private double calculateScalingRatio(double originalNumberOfEdges, double scaledNetworkNumberOfEdges) {
        DecimalFormat roundedRatioFormat = new DecimalFormat("#.###");
        return Double.valueOf(roundedRatioFormat.format(originalNumberOfEdges / scaledNetworkNumberOfEdges));
    }

    private void validateInputFile(File inData) throws ParsingException, AlgorithmExecutionException {
        ValidateNWBFile validateParser = new ValidateNWBFile();
        try {
            validateParser.validateNWBFormat(inData);
            this.numberOfNodes = validateParser.getTotalNumOfNodes();
            this.isUndirectedNetwork = validateParser.isUndirectedGraph();
            this.numberOfEdges = this.isUndirectedNetwork ? validateParser.getTotalNumOfUndirectedEdges() : validateParser.getTotalNumOfDirectedEdges();
        }
        catch (Exception exception) {
            throw new AlgorithmExecutionException("Inappropriate NWB File provided.");
        }
    }
}

