/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.pathfindernetworkscaling.fast;

import edu.iu.nwb.preprocessing.pathfindernetworkscaling.fast.FastPathfinderNetworkScalingAlgorithm;
import edu.iu.nwb.util.nwbfile.GetNWBFileMetadata;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class FastPathfinderNetworkScalingAlgorithmFactory
implements AlgorithmFactory,
ParameterMutator {
    private static final String UNWEIGHTED_WARNING = "Unweighted (Cannot be Scaled using Fast Pathfinder.)";
    private static final String UNWEIGHTED_USE_MST_WARNING = "Unweighted (Cannot be Scaled using Fast Pathfinder, use MST Pathfinder instead.)";
    private LogService log;
    private boolean isUnweighted;

    public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        return new FastPathfinderNetworkScalingAlgorithm(data, parameters, context, this.isUnweighted);
    }

    protected void activate(ComponentContext ctxt) {
        ServiceReference logReference = ctxt.getBundleContext().getServiceReference(LogService.class.getName());
        this.log = (LogService)ctxt.getBundleContext().getService(logReference);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition parameters) {
        String[] edgeAttributesArray;
        LinkedHashMap edgeSchema;
        boolean isUndirected;
        BasicObjectClassDefinition definition;
        File nwbFile = (File)data[0].getData();
        GetNWBFileMetadata metaDataHandler = new GetNWBFileMetadata();
        try {
            NWBFileParser parser = new NWBFileParser(nwbFile);
            parser.parse((NWBFileParserHandler)metaDataHandler);
        }
        catch (IOException iOException) {
            this.log.log(2, "Error occurred while trying to open NWB file '" + nwbFile.getAbsolutePath() + "'.");
            return parameters;
        }
        catch (ParsingException e) {
            this.log.log(2, "Error occurred while trying to parse NWB file.", (Throwable)e);
            return parameters;
        }
        try {
            definition = new BasicObjectClassDefinition(parameters.getID(), parameters.getName(), parameters.getDescription(), parameters.getIcon(16));
        }
        catch (IOException iOException) {
            definition = new BasicObjectClassDefinition(parameters.getID(), parameters.getName(), parameters.getDescription(), null);
        }
        if (metaDataHandler.getDirectedEdgeSchema() != null) {
            isUndirected = false;
            edgeSchema = metaDataHandler.getDirectedEdgeSchema();
            edgeAttributesArray = this.getNumericEdgeAttributes(edgeSchema, isUndirected);
        } else {
            isUndirected = true;
            edgeSchema = metaDataHandler.getUndirectedEdgeSchema();
            edgeAttributesArray = this.getNumericEdgeAttributes(edgeSchema, isUndirected);
        }
        this.isUnweighted = this.isNetworkWeighted(edgeAttributesArray);
        AttributeDefinition[] definitions = parameters.getAttributeDefinitions(-1);
        int ii = 0;
        while (ii < definitions.length) {
            String id = definitions[ii].getID();
            if (id.equals("weightcolumn")) {
                definition.addAttributeDefinition(1, (AttributeDefinition)new BasicAttributeDefinition(definitions[ii].getID(), definitions[ii].getName(), definitions[ii].getDescription(), definitions[ii].getType(), edgeAttributesArray, edgeAttributesArray));
            } else {
                definition.addAttributeDefinition(1, definitions[ii]);
            }
            ++ii;
        }
        return definition;
    }

    private boolean isNetworkWeighted(String[] edgeAttributesArray) {
        return edgeAttributesArray.length == 1 && (edgeAttributesArray[0].equalsIgnoreCase(UNWEIGHTED_USE_MST_WARNING) || edgeAttributesArray[0].equalsIgnoreCase(UNWEIGHTED_WARNING));
    }

    private String[] getNumericEdgeAttributes(Map edgeSchema, boolean isUndirected) {
        ArrayList<String> numericKeys = new ArrayList<String>();
        Iterator keysSkip = edgeSchema.keySet().iterator();
        keysSkip.next();
        keysSkip.next();
        Iterator keys = keysSkip;
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (edgeSchema.get(key).equals("string")) continue;
            numericKeys.add(key);
        }
        if (numericKeys.size() < 1) {
            if (isUndirected) {
                numericKeys.add(UNWEIGHTED_USE_MST_WARNING);
            } else {
                numericKeys.add(UNWEIGHTED_WARNING);
            }
        }
        return numericKeys.toArray(new String[0]);
    }
}

