/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.pathfindernetworkscaling.fast;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.service.log.LogService;

public class FastPathfinderNetworkScalingComputation
implements NWBFileParserHandler {
    private static final double DEFAULT_EDGE_WEIGHT = 1.0;
    private Map nodeIDToMatrixIndex = new HashMap();
    private int nodeCount = 0;
    private int numberOfNodes;
    private String edgeWeightColumnName;
    private String edgeWeightType;
    private double rParameter;
    private LogService logger;
    private DoubleMatrix2D weightMatrix;
    private DoubleMatrix2D distanceMatrix;

    public FastPathfinderNetworkScalingComputation(String edgeWeightColumnName, String edgeWeightType, double rParameter, int numberOfNodes, LogService logger) {
        this.edgeWeightType = edgeWeightType;
        this.edgeWeightColumnName = edgeWeightColumnName;
        this.rParameter = rParameter;
        this.numberOfNodes = numberOfNodes;
        this.logger = logger;
        this.initializeFastPathfinderMatrices();
    }

    private void initializeFastPathfinderMatrices() {
        DoubleFactory2D matrixFactory = DoubleFactory2D.sparse;
        DoubleFactory2D distanceMatrixFactory = DoubleFactory2D.dense;
        this.weightMatrix = matrixFactory.make(this.numberOfNodes, this.numberOfNodes);
        this.distanceMatrix = distanceMatrixFactory.make(this.numberOfNodes, this.numberOfNodes);
        this.weightMatrix.assign(Double.POSITIVE_INFINITY);
        this.distanceMatrix.assign(Double.POSITIVE_INFINITY);
    }

    private void setMatrixElements(int node1, int node2, Map edgeAttributes, boolean isUnDirectedEdge) {
        double edgeWeight = this.getEdgeWeight(node1, node2, edgeAttributes);
        int matrixRowIndex = (Integer)this.nodeIDToMatrixIndex.get(node1);
        int matrixColumnIndex = (Integer)this.nodeIDToMatrixIndex.get(node2);
        this.weightMatrix.set(matrixRowIndex, matrixColumnIndex, edgeWeight);
        this.distanceMatrix.set(matrixRowIndex, matrixColumnIndex, edgeWeight);
        if (isUnDirectedEdge) {
            this.weightMatrix.set(matrixColumnIndex, matrixRowIndex, edgeWeight);
            this.distanceMatrix.set(matrixColumnIndex, matrixRowIndex, edgeWeight);
        }
    }

    private double getEdgeWeight(int node1, int node2, Map edgeAttributes) {
        double edgeWeight;
        try {
            edgeWeight = Double.parseDouble(edgeAttributes.get(this.edgeWeightColumnName).toString());
        }
        catch (Exception exception) {
            edgeWeight = 1.0;
        }
        if (edgeWeight <= 0.0) {
            edgeWeight = 1.0;
            this.logger.log(2, "Edge weight for " + node1 + " - " + node2 + " should be more than 0. Default " + "value of \"Edge Weight\" (" + 1.0 + ") used.");
        }
        if (this.edgeWeightType.equalsIgnoreCase("SIMILARITY")) {
            edgeWeight = 1.0 / edgeWeight;
        }
        return edgeWeight;
    }

    public void addNode(int id, String label, Map attributes) {
        this.nodeIDToMatrixIndex.put(id, this.nodeCount++);
    }

    public void addDirectedEdge(int sourceNode, int targetNode, Map attributes) {
        this.setMatrixElements(sourceNode, targetNode, attributes, false);
    }

    public void addUndirectedEdge(int node1, int node2, Map attributes) {
        this.setMatrixElements(node1, node2, attributes, true);
    }

    public void finishedParsing() {
        this.computeMinimumWeightPaths();
    }

    private void computeMinimumWeightPaths() {
        int k = 0;
        while (k < this.numberOfNodes) {
            int i = 0;
            while (i < this.numberOfNodes) {
                int j = 0;
                while (j < this.numberOfNodes) {
                    this.distanceMatrix.set(i, j, this.getMinimumCostPathWeight(i, j, k));
                    ++j;
                }
                ++i;
            }
            ++k;
        }
    }

    private double getMinimumCostPathWeight(int i, int j, int k) {
        if (this.rParameter < Double.POSITIVE_INFINITY) {
            double intermediatePathWeight = Math.pow(Math.pow(this.distanceMatrix.get(i, k), this.rParameter) + Math.pow(this.distanceMatrix.get(k, j), this.rParameter), 1.0 / this.rParameter);
            return Math.min(this.distanceMatrix.get(i, j), intermediatePathWeight);
        }
        return Math.min(this.distanceMatrix.get(i, j), Math.max(this.distanceMatrix.get(i, k), this.distanceMatrix.get(k, j)));
    }

    public boolean haltParsingNow() {
        return false;
    }

    public double getWeightMatrixElement(int row, int column) {
        int matrixRowIndex = (Integer)this.nodeIDToMatrixIndex.get(row);
        int matrixColumnIndex = (Integer)this.nodeIDToMatrixIndex.get(column);
        return this.weightMatrix.get(matrixRowIndex, matrixColumnIndex);
    }

    public double getDistanceMatrixElement(int row, int column) {
        int matrixRowIndex = (Integer)this.nodeIDToMatrixIndex.get(row);
        int matrixColumnIndex = (Integer)this.nodeIDToMatrixIndex.get(column);
        return this.distanceMatrix.get(matrixRowIndex, matrixColumnIndex);
    }

    public void addComment(String comment) {
    }

    public void setDirectedEdgeCount(int numberOfEdges) {
    }

    public void setDirectedEdgeSchema(LinkedHashMap schema) {
    }

    public void setNodeCount(int numberOfNodes) {
    }

    public void setNodeSchema(LinkedHashMap schema) {
    }

    public void setUndirectedEdgeCount(int numberOfEdges) {
    }

    public void setUndirectedEdgeSchema(LinkedHashMap schema) {
    }
}

