/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.pathfindernetworkscaling.fast;

import edu.iu.nwb.preprocessing.pathfindernetworkscaling.fast.FastPathfinderNetworkScalingComputation;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileWriter;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class FastPathfinderNetworkScalingOutputGenerator
implements NWBFileParserHandler {
    private NWBFileWriter output;
    private int scaledNetworkEdgeCount;
    private FastPathfinderNetworkScalingComputation scaledNetworkOutput;

    public int getScaledNetworkEdgeCount() {
        return this.scaledNetworkEdgeCount;
    }

    public FastPathfinderNetworkScalingOutputGenerator(FastPathfinderNetworkScalingComputation scaledNetworkOutput, File outputNWBFile) throws IOException {
        this.output = new NWBFileWriter(outputNWBFile);
        this.scaledNetworkEdgeCount = 0;
        this.scaledNetworkOutput = scaledNetworkOutput;
    }

    public void setNodeCount(int numberOfNodes) {
        this.output.setNodeCount(numberOfNodes);
    }

    public void setNodeSchema(LinkedHashMap schema) {
        this.output.setNodeSchema(schema);
    }

    public void addNode(int id, String label, Map attributes) {
        this.output.addNode(id, label, attributes);
    }

    public void addDirectedEdge(int sourceNode, int targetNode, Map attributes) {
        this.setEdgeRows(sourceNode, targetNode, attributes, false);
    }

    public void addUndirectedEdge(int node1, int node2, Map attributes) {
        this.setEdgeRows(node1, node2, attributes, true);
    }

    private void setEdgeRows(int node1, int node2, Map attributes, boolean isUndirected) {
        if (this.scaledNetworkOutput.getDistanceMatrixElement(node1, node2) == this.scaledNetworkOutput.getWeightMatrixElement(node1, node2)) {
            if (isUndirected) {
                this.output.addUndirectedEdge(node1, node2, attributes);
            } else {
                this.output.addDirectedEdge(node1, node2, attributes);
            }
            ++this.scaledNetworkEdgeCount;
        }
    }

    public void setDirectedEdgeCount(int numberOfEdges) {
        this.output.setDirectedEdgeCount(numberOfEdges);
    }

    public void setDirectedEdgeSchema(LinkedHashMap schema) {
        this.output.setDirectedEdgeSchema(schema);
    }

    public void setUndirectedEdgeCount(int numberOfEdges) {
        this.output.setUndirectedEdgeCount(numberOfEdges);
    }

    public void setUndirectedEdgeSchema(LinkedHashMap schema) {
        this.output.setUndirectedEdgeSchema(schema);
    }

    public void addComment(String comment) {
        this.output.addComment(comment);
    }

    public void finishedParsing() {
        this.output.finishedParsing();
    }

    public boolean haltParsingNow() {
        return false;
    }
}

