/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.pathfindernetworkscaling.mst;

import edu.iu.nwb.converter.nwb.common.ValidateNWBFile;
import edu.iu.nwb.preprocessing.pathfindernetworkscaling.mst.MSTPathfinderNetworkScalingComputation;
import edu.iu.nwb.preprocessing.pathfindernetworkscaling.mst.MSTPathfinderNetworkScalingOutputGenerator;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;

public class MSTPathfinderNetworkScalingAlgorithm
implements Algorithm {
    private Data[] data;
    private Dictionary parameters;
    private CIShellContext context;
    private LogService logger;
    private int numberOfEdges;
    private int numberOfNodes;
    private boolean isUndirectedNetwork;
    public static final String WEIGHT_DISSIMILARITY = "DISSIMILARITY";
    public static final String WEIGHT_SIMILARITY = "SIMILARITY";

    public MSTPathfinderNetworkScalingAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        File inputData = (File)this.data[0].getData();
        try {
            this.validateInputFile(inputData);
        }
        catch (ParsingException e) {
            throw new AlgorithmExecutionException("Inappropriate NWB File provided.", (Throwable)e);
        }
        if (this.isUndirectedNetwork && this.numberOfEdges > 1 && this.numberOfNodes > 1) {
            try {
                String edgeWeightColumnName = (String)this.parameters.get("weightcolumn");
                String edgeWeightType = (String)this.parameters.get("weighttypecolumn");
                NWBFileParser parser = new NWBFileParser(inputData);
                MSTPathfinderNetworkScalingComputation networkScalingComputation = new MSTPathfinderNetworkScalingComputation(edgeWeightColumnName, edgeWeightType, this.logger);
                parser.parse((NWBFileParserHandler)networkScalingComputation);
                File outputNWBFile = File.createTempFile("nwb-", ".nwb");
                NWBFileParser outputParser = new NWBFileParser(inputData);
                outputParser.parse((NWBFileParserHandler)new MSTPathfinderNetworkScalingOutputGenerator(networkScalingComputation, outputNWBFile));
                BasicData outNWBData = new BasicData((Object)outputNWBFile, "file:text/nwb");
                this.prepareOutputMetadata(edgeWeightType, networkScalingComputation, (Data)outNWBData);
                return new Data[]{outNWBData};
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new AlgorithmExecutionException("NWB File'" + inputData.getAbsolutePath() + "' not found.");
            }
            catch (IOException e) {
                throw new AlgorithmExecutionException((Throwable)e);
            }
            catch (ParsingException e) {
                throw new AlgorithmExecutionException((Throwable)e);
            }
        }
        throw new AlgorithmExecutionException("Input network should be Undirected with more than 1 edge & 1 node.");
    }

    private void prepareOutputMetadata(String edgeWeightType, MSTPathfinderNetworkScalingComputation networkScalingComputation, Data outNWBData) {
        outNWBData.getMetadata().put("Label", "MST Pathfinder Network Scaling used weight " + edgeWeightType + " to reduce " + this.numberOfEdges + " edges to " + networkScalingComputation.getScaledNetworkEdgeCount() + ". Scaling ratio = " + this.calculateScalingRatio(this.numberOfEdges, networkScalingComputation.getScaledNetworkEdgeCount()));
        outNWBData.getMetadata().put("Type", "Network");
        outNWBData.getMetadata().put("Parent", this.data[0]);
    }

    private double calculateScalingRatio(double eoriginalNumberOfEdges, double scaledNetworkNumberOfEdges) {
        DecimalFormat roundedRatioFormat = new DecimalFormat("#.###");
        return Double.valueOf(roundedRatioFormat.format(eoriginalNumberOfEdges / scaledNetworkNumberOfEdges));
    }

    private void validateInputFile(File inData) throws ParsingException, AlgorithmExecutionException {
        ValidateNWBFile validateParser = new ValidateNWBFile();
        try {
            validateParser.validateNWBFormat(inData);
            this.numberOfNodes = validateParser.getTotalNumOfNodes();
            this.numberOfEdges = validateParser.getTotalNumOfUndirectedEdges();
            this.isUndirectedNetwork = validateParser.isUndirectedGraph();
        }
        catch (Exception exception) {
            throw new AlgorithmExecutionException("Inappropriate NWB File provided.");
        }
    }
}

