/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.pathfindernetworkscaling.mst;

import edu.iu.nwb.preprocessing.pathfindernetworkscaling.mst.MSTPathfinderNetworkScalingAlgorithm;
import edu.iu.nwb.util.nwbfile.GetNWBFileMetadata;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Map;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class MSTPathfinderNetworkScalingAlgorithmFactory
implements AlgorithmFactory,
ParameterMutator {
    public static final String NO_EDGE_WEIGHT_IDENTIFIER = "Unweighted";

    public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        return new MSTPathfinderNetworkScalingAlgorithm(data, parameters, context);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition parameters) {
        BasicObjectClassDefinition definition;
        File nwbFile = (File)data[0].getData();
        GetNWBFileMetadata metaDataHandler = new GetNWBFileMetadata();
        try {
            NWBFileParser parser = new NWBFileParser(nwbFile);
            parser.parse((NWBFileParserHandler)metaDataHandler);
        }
        catch (IOException iOException) {
            return parameters;
        }
        catch (ParsingException parsingException) {
            return parameters;
        }
        try {
            definition = new BasicObjectClassDefinition(parameters.getID(), parameters.getName(), parameters.getDescription(), parameters.getIcon(16));
        }
        catch (IOException iOException) {
            definition = new BasicObjectClassDefinition(parameters.getID(), parameters.getName(), parameters.getDescription(), null);
        }
        String[] edgeAttributesArray = metaDataHandler.getDirectedEdgeSchema() != null ? this.createKeyArray(metaDataHandler.getDirectedEdgeSchema()) : this.createKeyArray(metaDataHandler.getUndirectedEdgeSchema());
        AttributeDefinition[] definitions = parameters.getAttributeDefinitions(-1);
        int ii = 0;
        while (ii < definitions.length) {
            String id = definitions[ii].getID();
            if (id.equals("weightcolumn")) {
                definition.addAttributeDefinition(1, (AttributeDefinition)new BasicAttributeDefinition(definitions[ii].getID(), definitions[ii].getName(), definitions[ii].getDescription(), definitions[ii].getType(), edgeAttributesArray, edgeAttributesArray));
            } else {
                definition.addAttributeDefinition(1, definitions[ii]);
            }
            ++ii;
        }
        return definition;
    }

    private String[] createKeyArray(Map schema) {
        ArrayList<String> goodkeys = new ArrayList<String>();
        Iterator keysSkip = schema.keySet().iterator();
        keysSkip.next();
        keysSkip.next();
        Iterator keys = keysSkip;
        while (keys.hasNext()) {
            String key = "" + keys.next();
            if (schema.get(key).equals("string")) continue;
            goodkeys.add(key);
        }
        goodkeys.add(NO_EDGE_WEIGHT_IDENTIFIER);
        Collections.reverse(goodkeys);
        return goodkeys.toArray(new String[0]);
    }
}

