/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.pathfindernetworkscaling.mst;

import edu.iu.nwb.preprocessing.pathfindernetworkscaling.mst.EdgeTuple;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.log.LogService;

public class MSTPathfinderNetworkScalingComputation
implements NWBFileParserHandler {
    private static final double DEFAULT_EDGE_WEIGHT = 1.0;
    private Map nodeIDToClusterID = new HashMap();
    private Map clusterIDToNodes = new HashMap();
    private List edges = new ArrayList();
    private List alternativeEdges = new ArrayList();
    public Set finalEdges = new HashSet();
    private int edgeCount = 0;
    private String edgeWeightColumnName;
    private String edgeWeightType;
    private LogService logger;

    public MSTPathfinderNetworkScalingComputation(String edgeWeightColumnName, String edgeWeightType, LogService logger) {
        this.edgeWeightType = edgeWeightType;
        this.edgeWeightColumnName = edgeWeightColumnName;
        this.logger = logger;
    }

    private void createEdgeTupleElements(int node1, int node2, Map attributes, boolean isUnDirectedEdge) {
        double edgeWeight;
        try {
            edgeWeight = Double.parseDouble(attributes.get(this.edgeWeightColumnName).toString());
        }
        catch (Exception exception) {
            edgeWeight = 1.0;
        }
        if (edgeWeight <= 0.0) {
            edgeWeight = 1.0;
            this.logger.log(2, "Edge weight for " + node1 + " - " + node2 + " should be more than 0. Default " + "value of \"Edge Weight\" (" + 1.0 + ") used.");
        }
        if (this.edgeWeightType.equalsIgnoreCase("SIMILARITY")) {
            edgeWeight = 1.0 / edgeWeight;
        }
        this.edges.add(new EdgeTuple(this.edgeCount, node1, node2, edgeWeight));
        this.alternativeEdges.add(new EdgeTuple(this.edgeCount, node1, node2, edgeWeight));
        ++this.edgeCount;
    }

    public void addNode(int id, String label, Map attributes) {
        this.nodeIDToClusterID.put(id, id);
        ArrayList<Integer> nodes = new ArrayList<Integer>();
        nodes.add(id);
        this.clusterIDToNodes.put(id, nodes);
    }

    public void addUndirectedEdge(int node1, int node2, Map attributes) {
        this.createEdgeTupleElements(node1, node2, attributes, true);
    }

    public void finishedParsing() {
        Collections.sort(this.edges);
        Collections.sort(this.alternativeEdges);
        this.pruneEdgeList();
    }

    private void pruneEdgeList() {
        Iterator edgeIterator = this.edges.iterator();
        block0: while (edgeIterator.hasNext()) {
            double currentEdgeWeight = ((EdgeTuple)edgeIterator.next()).getWeight();
            new ArrayList();
            Iterator alternativeEdgesIterator = this.alternativeEdges.iterator();
            while (alternativeEdgesIterator.hasNext()) {
                EdgeTuple currentAlternativeEdge = (EdgeTuple)alternativeEdgesIterator.next();
                double currentAlternativeEdgeWeight = currentAlternativeEdge.getWeight();
                if (currentAlternativeEdgeWeight == currentEdgeWeight) {
                    alternativeEdgesIterator.remove();
                    int[] edgePoints = new int[]{currentAlternativeEdge.getNode1(), currentAlternativeEdge.getNode2()};
                    int edgeID = currentAlternativeEdge.getNodeID();
                    int cluster1ID = (Integer)this.nodeIDToClusterID.get(edgePoints[0]);
                    int cluster2ID = (Integer)this.nodeIDToClusterID.get(edgePoints[1]);
                    if (cluster1ID == cluster2ID) continue;
                    this.finalEdges.add(edgeID);
                    this.mergeClusters(cluster1ID, cluster2ID);
                    continue;
                }
                if (currentAlternativeEdgeWeight > currentEdgeWeight) continue block0;
            }
        }
    }

    public int getScaledNetworkEdgeCount() {
        return this.finalEdges.size();
    }

    private void mergeClusters(int cluster1ID, int cluster2ID) {
        List cluster1 = (List)this.clusterIDToNodes.get(cluster1ID);
        List cluster2 = (List)this.clusterIDToNodes.get(cluster2ID);
        if (cluster1.size() > cluster2.size()) {
            Iterator clusterIterator = cluster2.iterator();
            while (clusterIterator.hasNext()) {
                this.nodeIDToClusterID.put((Integer)clusterIterator.next(), cluster1ID);
            }
            cluster1.addAll(cluster2);
            this.clusterIDToNodes.remove(cluster2ID);
        } else {
            Iterator clusterIterator = cluster1.iterator();
            while (clusterIterator.hasNext()) {
                this.nodeIDToClusterID.put((Integer)clusterIterator.next(), cluster2ID);
            }
            cluster2.addAll(cluster1);
            this.clusterIDToNodes.remove(cluster1ID);
        }
    }

    public void addDirectedEdge(int sourceNode, int targetNode, Map attributes) {
    }

    public boolean haltParsingNow() {
        return false;
    }

    public void addComment(String comment) {
    }

    public void setDirectedEdgeCount(int numberOfEdges) {
    }

    public void setDirectedEdgeSchema(LinkedHashMap schema) {
    }

    public void setNodeCount(int numberOfNodes) {
    }

    public void setNodeSchema(LinkedHashMap schema) {
    }

    public void setUndirectedEdgeCount(int numberOfEdges) {
    }

    public void setUndirectedEdgeSchema(LinkedHashMap schema) {
    }
}

