/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.pathfindernetworkscaling.mst;

import edu.iu.nwb.preprocessing.pathfindernetworkscaling.mst.MSTPathfinderNetworkScalingComputation;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileWriter;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class MSTPathfinderNetworkScalingOutputGenerator
implements NWBFileParserHandler {
    private NWBFileWriter output;
    private NWBFileParser parser;
    private File edgeFile;
    private Set finalEdges;
    private int edgeCount;
    public int scaledNetworkEdgeCount;

    public MSTPathfinderNetworkScalingOutputGenerator(MSTPathfinderNetworkScalingComputation scaledNetworkOutput, File outputNWBFile) throws IOException {
        this.output = new NWBFileWriter(outputNWBFile);
        this.finalEdges = scaledNetworkOutput.finalEdges;
        this.edgeCount = 0;
    }

    public void setNodeCount(int numberOfNodes) {
        this.output.setNodeCount(numberOfNodes);
    }

    public void setNodeSchema(LinkedHashMap schema) {
        this.output.setNodeSchema(schema);
    }

    public void addNode(int id, String label, Map attributes) {
        this.output.addNode(id, label, attributes);
    }

    public void addDirectedEdge(int sourceNode, int targetNode, Map attributes) {
        this.output.addDirectedEdge(sourceNode, targetNode, attributes);
    }

    public void addUndirectedEdge(int node1, int node2, Map attributes) {
        if (this.finalEdges.contains(this.edgeCount)) {
            this.output.addUndirectedEdge(node1, node2, attributes);
        }
        ++this.edgeCount;
    }

    public void setDirectedEdgeCount(int numberOfEdges) {
        this.output.setDirectedEdgeCount(numberOfEdges);
    }

    public void setDirectedEdgeSchema(LinkedHashMap schema) {
        this.output.setDirectedEdgeSchema(schema);
    }

    public void setUndirectedEdgeCount(int numberOfEdges) {
        this.output.setUndirectedEdgeCount(numberOfEdges);
    }

    public void setUndirectedEdgeSchema(LinkedHashMap schema) {
        this.output.setUndirectedEdgeSchema(schema);
    }

    public void addComment(String comment) {
        this.output.addComment(comment);
    }

    public void finishedParsing() {
        this.output.finishedParsing();
    }

    public boolean haltParsingNow() {
        return false;
    }
}

