/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.prefuse.beta.directoryhierarchyreader;

import java.io.File;
import java.io.FileFilter;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Tree;

public class DirectoryHierarchyReader {
    public static final int INDEFINITE = -1;
    private static final String labelKey = "label";
    private static final FileFilter fileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile();
        }
    };
    private static final FileFilter dirFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };

    public static Graph readDirectory(File directory, int levels, boolean readFiles) {
        Tree tree = new Tree();
        String LABEL = labelKey;
        Schema LABEL_SCHEMA = new Schema();
        LABEL_SCHEMA.addColumn(LABEL, String.class, (Object)"");
        tree.addColumns(LABEL_SCHEMA);
        Node rootNode = tree.addRoot();
        DirectoryHierarchyReader.readDirectory(rootNode, directory, 0, levels, readFiles);
        return tree;
    }

    private static void readDirectory(Node node, File curDir, int curLevel, int levels, boolean readFiles) {
        File[] dirList;
        int i;
        node.setString(labelKey, curDir.getName());
        if (curLevel == levels) {
            return;
        }
        if (readFiles) {
            File[] fileList = curDir.listFiles(fileFilter);
            if (fileList == null) {
                fileList = new File[]{};
            }
            i = 0;
            while (i < fileList.length) {
                Node tnFile = ((Tree)node.getGraph()).addChild(node);
                tnFile.setString(labelKey, fileList[i].getName());
                ++i;
            }
        }
        if ((dirList = curDir.listFiles(dirFilter)) == null) {
            dirList = new File[]{};
        }
        i = 0;
        while (i < dirList.length) {
            Node tnDir = ((Tree)node.getGraph()).addChild(node);
            DirectoryHierarchyReader.readDirectory(tnDir, dirList[i], curLevel + 1, levels, readFiles);
            ++i;
        }
    }
}

