/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.prefuse.beta.directoryhierarchyreader;

import edu.iu.nwb.preprocessing.prefuse.beta.directoryhierarchyreader.DirectoryHierarchyReader;
import java.io.File;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import prefuse.data.Graph;
import prefuse.data.Tree;

public class DirectoryHierarchyReaderAlgorithm
implements Algorithm {
    Data[] data;
    Dictionary parameters;
    CIShellContext context;

    public DirectoryHierarchyReaderAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
    }

    public Data[] execute() {
        String myregex = "[a-zA-Z]:";
        String rootParam = (String)this.parameters.get("rootDirectory");
        if (rootParam.matches(myregex)) {
            rootParam = String.valueOf(rootParam) + "\\";
        }
        File rootFile = new File(rootParam);
        int numLevels = (Integer)this.parameters.get("level");
        boolean doRecurseTree = (Boolean)this.parameters.get("doRecurse");
        boolean doSkipFiles = (Boolean)this.parameters.get("readDirectories");
        if (doRecurseTree) {
            numLevels = -1;
        }
        Graph g = DirectoryHierarchyReader.readDirectory(rootFile, numLevels, !doSkipFiles);
        BasicData dm = new BasicData((Object)g, Tree.class.getName());
        dm.getMetadata().put("Label", "Directory Tree - Prefuse (Beta) Graph");
        dm.getMetadata().put("Type", "Tree");
        return new Data[]{dm};
    }
}

