/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.tablefilter;

import edu.iu.nwb.preprocessing.tablefilter.Filter;
import java.util.Dictionary;
import java.util.List;
import java.util.regex.Pattern;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.cishell.utilities.MutateParameterUtilities;
import org.cishell.utilities.TableUtilities;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;
import prefuse.data.Schema;
import prefuse.data.Table;

public class FilterFactory
implements AlgorithmFactory,
ParameterMutator {
    public static final String SEPARATOR_KEY = "separator";
    public static final String COLUMN_KEY = "column";
    public static final String CUTOFF_KEY = "cutoff";

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        Data inputData = data[0];
        Table inputTable = (Table)inputData.getData();
        String separator = (String)parameters.get(SEPARATOR_KEY);
        Pattern pattern = Pattern.compile("\\Q" + separator + "\\E");
        String column = (String)parameters.get(COLUMN_KEY);
        int cutoff = (Integer)parameters.get(CUTOFF_KEY);
        return new Filter(inputData, inputTable, pattern, column, cutoff);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldParameters) {
        Data inputData = data[0];
        Table inputTable = (Table)inputData.getData();
        BasicObjectClassDefinition newParameters = MutateParameterUtilities.createNewParameters((ObjectClassDefinition)oldParameters);
        AttributeDefinition[] attributeDefinitionArray = oldParameters.getAttributeDefinitions(-1);
        int n = attributeDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDefinition attribute = attributeDefinitionArray[n2];
            if (COLUMN_KEY.equals(attribute.getID())) {
                List columnNames = TableUtilities.getAllColumnNames((Schema)inputTable.getSchema());
                String[] columnNameOptions = columnNames.toArray(new String[0]);
                BasicAttributeDefinition columnAttribute = new BasicAttributeDefinition(COLUMN_KEY, attribute.getName(), attribute.getDescription(), attribute.getType(), columnNameOptions, columnNameOptions);
                newParameters.addAttributeDefinition(1, (AttributeDefinition)columnAttribute);
            } else {
                newParameters.addAttributeDefinition(1, attribute);
            }
            ++n2;
        }
        return newParameters;
    }
}

