/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.text.normalization;

import edu.iu.nwb.preprocessing.text.normalization.StandardNormalizer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmCreationFailedException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.cishell.utilities.MutateParameterUtilities;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;
import prefuse.data.Schema;
import prefuse.data.Table;

public class StandardNormalizerFactory
implements AlgorithmFactory,
ParameterMutator {
    public static final String SEPARATOR_KEY = "separator";
    public static final String STOP_WORD_LIST_FILE = "stopWordListFile";
    public static final String PREFIX = "column_";
    public static final String DEFAULT_STOP_WORD_LIST_FILE_NAME = "stopwords.txt";
    public static final String DEFAULT_STOP_WORD_LIST_FILE_PATH = "/edu/iu/nwb/preprocessing/text/normalization/stopwords.txt";
    private BundleContext bundleContext;
    private boolean usingDefaultStopWords = false;

    protected void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
    }

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        Data inputData = data[0];
        Table inputTable = (Table)inputData.getData();
        LogService logger = (LogService)ciShellContext.getService(LogService.class.getName());
        String separator = (String)parameters.get(SEPARATOR_KEY);
        String stopWordListFilePath = (String)parameters.get(STOP_WORD_LIST_FILE);
        Set<String> columnsToNormalize = this.determineColumnsToNormalize(parameters);
        String[] stopWords = this.getStopWords(stopWordListFilePath);
        return new StandardNormalizer(inputData, inputTable, logger, separator, columnsToNormalize, stopWords, this.usingDefaultStopWords);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldParameters) {
        String id;
        AttributeDefinition attributeDefinition;
        AttributeDefinition[] attributeDefinitions;
        Table inputTable = (Table)data[0].getData();
        String[] columnNames = this.createKeyArray(inputTable.getSchema());
        BasicObjectClassDefinition newParameters = MutateParameterUtilities.createNewParameters((ObjectClassDefinition)oldParameters);
        AttributeDefinition[] attributeDefinitionArray = attributeDefinitions = oldParameters.getAttributeDefinitions(-1);
        int n = attributeDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            attributeDefinition = attributeDefinitionArray[n2];
            id = attributeDefinition.getID();
            if (STOP_WORD_LIST_FILE.equals(id)) {
                String name = attributeDefinition.getName();
                String description = attributeDefinition.getDescription();
                int type = attributeDefinition.getType();
                String defaultValue = "file:" + this.getDefaultStopWordListFileLocation(attributeDefinition.getDefaultValue()[0]);
                BasicAttributeDefinition newAttributeDefinition = new BasicAttributeDefinition(id, name, description, type, defaultValue){

                    public String validate(String value) {
                        return super.validate(value);
                    }
                };
                newParameters.addAttributeDefinition(2, (AttributeDefinition)newAttributeDefinition);
            }
            ++n2;
        }
        attributeDefinitionArray = attributeDefinitions;
        n = attributeDefinitions.length;
        n2 = 0;
        while (n2 < n) {
            attributeDefinition = attributeDefinitionArray[n2];
            id = attributeDefinition.getID();
            if (!STOP_WORD_LIST_FILE.equals(id)) {
                newParameters.addAttributeDefinition(1, attributeDefinition);
            }
            ++n2;
        }
        this.addBooleanOptions(oldParameters, newParameters, columnNames, PREFIX);
        return newParameters;
    }

    private Set<String> determineColumnsToNormalize(Dictionary<String, Object> parameters) {
        TreeSet<String> columns = new TreeSet<String>();
        Enumeration<String> keys = parameters.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Boolean truth = new Boolean(true);
            if (!key.startsWith(PREFIX) || !truth.equals(parameters.get(key))) continue;
            String column = key.substring(PREFIX.length());
            columns.add(column);
        }
        return columns;
    }

    private String[] getStopWords(String stopWordListFilePath) throws AlgorithmCreationFailedException {
        InputStream inStream = null;
        BufferedReader input = null;
        ArrayList<String> stopWordsSoFar = new ArrayList<String>();
        try {
            try {
                String line;
                inStream = this.determineStopWordListFilePath(stopWordListFilePath);
                input = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                while ((line = input.readLine()) != null) {
                    stopWordsSoFar.add(line);
                }
            }
            catch (Exception e) {
                throw new AlgorithmCreationFailedException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int index = 0;
        for (String stopWord : stopWordsSoFar) {
            System.err.println(String.format(">>Debug: index = %d, value = %s", index, stopWord));
            ++index;
        }
        return stopWordsSoFar.toArray(new String[0]);
    }

    private String[] createKeyArray(Schema schema) {
        ArrayList<String> keys = new ArrayList<String>();
        int ii = 0;
        while (ii < schema.getColumnCount()) {
            if (schema.getColumnType(ii).equals(String.class)) {
                keys.add(schema.getColumnName(ii));
            }
            ++ii;
        }
        return keys.toArray(new String[0]);
    }

    private String getDefaultStopWordListFileLocation(String defaultValue) {
        try {
            URL stopWordListFileURL = new URL(new URL(System.getProperty("osgi.configuration.area")), DEFAULT_STOP_WORD_LIST_FILE_NAME);
            String filePath = stopWordListFileURL.getFile();
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows") && (filePath.startsWith("\\") || filePath.startsWith("/"))) {
                filePath = filePath.substring(1);
            }
            return filePath;
        }
        catch (MalformedURLException malformedURLException) {
            return defaultValue;
        }
    }

    private void addBooleanOptions(ObjectClassDefinition oldParameters, BasicObjectClassDefinition newParameters, String[] columnNames, String prefix) {
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            String id = String.valueOf(prefix) + columnName;
            String name = columnName;
            String description = String.format("Normalize column %s?", columnName);
            int type = 11;
            newParameters.addAttributeDefinition(1, (AttributeDefinition)new BasicAttributeDefinition(id, name, description, type));
            ++n2;
        }
    }

    private InputStream determineStopWordListFilePath(String stopWordListFilePath) throws IOException {
        try {
            File stopWordListFile = new File(stopWordListFilePath);
            if (stopWordListFile.exists() && stopWordListFile.canRead() && stopWordListFile.isFile()) {
                return new BufferedInputStream(new FileInputStream(stopWordListFile));
            }
        }
        catch (Exception exception) {}
        this.usingDefaultStopWords = true;
        URL filePathURL = this.bundleContext.getBundle().getResource(DEFAULT_STOP_WORD_LIST_FILE_PATH);
        URLConnection connection = filePathURL.openConnection();
        connection.setDoInput(true);
        return connection.getInputStream();
    }
}

